theory question_61_4

imports Main

begin

typedecl entity

consts
  LargestCelestialBodyInSolarSystem :: "entity ⇒ bool"
  LargestBodyInSolarSystem :: "entity ⇒ bool"
  Sun :: "entity ⇒ bool"
  CelestialBody :: "entity ⇒ bool"

(* Explanation 1: The largest celestial body in our solar system is the Sun. *)
axiomatization where
  explanation_1: "∃x. LargestCelestialBodyInSolarSystem x ∧ Sun x"

(* Explanation 2: In our solar system, the largest body is a celestial body. *)
axiomatization where
  explanation_2: "∀x. LargestBodyInSolarSystem x ⟹ CelestialBody x"

(* Explanation 3: The Sun is a celestial body. *)
axiomatization where
  explanation_3: "∃x. Sun x ∧ CelestialBody x"

theorem hypothesis:
  assumes asm: "CelestialBody x"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "∃x. LargestBodyInSolarSystem x ∧ Sun x"
proof -
  have "∃x. LargestCelestialBodyInSolarSystem x ∧ Sun x" using explanation_1 by blast
  then obtain x where "LargestCelestialBodyInSolarSystem x ∧ Sun x" by blast
  then have "LargestBodyInSolarSystem x" using explanation_1 by blast
  then show ?thesis using asm `x` by blast
qed

end
