theory question_88_0
imports Main
begin
typedecl entity
typedecl event
consts
  Gymnast :: "entity ⇒ bool"
  Skills :: "entity ⇒ bool"
  Flip :: "event ⇒ bool"
  Display :: "event ⇒ bool"
  Does :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  Flooring :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Displaying skills with a flip is a rephrasing of "does a flip." *)
axiomatization where
  explanation_1: "∀x e. Gymnast x ∧ Skills x ∧ Flip e ∧ Display e ∧ Agent e x ∧ Patient e (Skills x) ⟷ Does e ∧ Agent e x ∧ Patient e (Flip e)"

theorem hypothesis:
  (* Premise: Gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip e ∧ Blue y ∧ Flooring y ∧ Does e ∧ Agent e x ∧ Patient e  Flip e  ∧ On e y"
  (* Hypothesis: A gymnast displays their skills with a flip *)
  shows "∃x e. Gymnast x ∧ Skills x ∧ Flip e ∧ Display e ∧ Agent e x ∧ Patient e  Skills x "
proof -
  from asm have "Gymnast x ∧ Flip e ∧ Agent e x ∧ Patient e (Flip e)" by blast
  then have "Gymnast x ∧ Skills x ∧ Flip e ∧ Display e ∧ Agent e x ∧ Patient e (Skills x)" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
