theory question_27_1

imports Main

begin
typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  OldMan :: "entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  Dirty :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"

(* Explanation 1: The man is on a dirty sidewalk. Sidewalks are found outdoors, therefore, the man is outside *)
axiomatization where
  explanation_1: "∃x y. Man x ∧ Sidewalk y ∧ Dirty y ∧ Outdoors y ∧ On x y ⟶ Outside x"

theorem hypothesis:
  (* Premise: A old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "OldMan x ∧ HardwareParts y ∧ Sidewalk z ∧ Dirty z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ On x z"
  (* Hypothesis: The man is outside. *)
  shows "∃x. Man x ∧ Outside x"
proof -
  from asm have "OldMan x" by blast
  from asm have "Sidewalk z" "Dirty z" "On x z" by blast
  from this have "Outside x" using explanation_1 by blast
  from asm have "Man x" using explanation_1(1) by blast
  show ?thesis using `Man x` `Outside x` by blast
qed

end
