theory question_65_10

imports Main

begin

typedecl entity
typedecl event

consts
  ElectricityFlows :: "entity ⇒ bool"
  Circuit :: "entity ⇒ bool"
  Necessary :: "entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: The flow of electricity through a circuit is necessary for a light bulb to turn on. *)
axiomatization where
  explanation_1: "∀x y z e. ElectricityFlows x ∧ Circuit y ∧ Necessary z ⟶ TurnOn e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: A switch in a simple series circuit being closed allows electricity to flow through the circuit. *)
axiomatization where
  explanation_2: "∀x y z e. Switch x ∧ SimpleSeriesCircuit y ∧ Closed z ⟶ Allows e ∧ Agent e x ∧ Patient e y"

(* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
axiomatization where
  hypothesis: "∀x y z e. ElectricityFlows x ∧ LightBulb y ∧ On z ⟶ Occurs e ∧ Agent e x ∧ Patient e y"

(* Premise: When the switch in a simple series circuit is closed. *)
assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed z"

(* Conclusion: The light bulb turns on. *)
shows "TurnOn e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Switch x ∧ SimpleSeriesCircuit y ∧ Closed z" by simp
  then obtain e1 where e1: "Allows e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_2 by blast
  then have "ElectricityFlows e1 ∧ Necessary e1 ∧ TurnOn e1" using explanation_1 by blast
  then show ?thesis using asm e1 by simp
qed

end
