theory question_23_0

imports Main

begin

typedecl entity

consts
  Hurricanes :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"
  HighWinds :: "entity ⇒ bool"
  HighWindSpeeds :: "entity ⇒ bool"

(* Explanation 1: a hurricane has high wind speeds. *)
axiomatization where
  explanation_1: "∀x. Hurricanes x ⟶ HighWindSpeeds x"

(* Explanation 2: a tornado has high wind speeds. *)
axiomatization where
  explanation_2: "∀y. Tornadoes y ⟶ HighWindSpeeds y"  

theorem hypothesis:
  assumes asm: "Hurricanes x ∧ Tornadoes y"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "HighWinds x ∧ HighWinds y"
proof -
  from asm have "Hurricanes x" by simp
  then have "HighWinds x" using explanation_1 by blast
  from asm have "Tornadoes y" by simp
  then have "HighWinds y" using explanation_2 by blast
  show ?thesis using `HighWinds x` `HighWinds y` by blast
qed

end
