theory question_16_0

imports Main

begin

typedecl entity

consts
  Viruses :: "entity ⇒ bool"
  Phospholipids :: "entity ⇒ bool"
  Proteins :: "entity ⇒ bool"
  Have :: "entity ⇒ entity ⇒ bool"
  Coats :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Some viruses have an envelope of phospholipids and proteins. *)
axiomatization where
  explanation_1: "∃x y z. Viruses x ∧ Phospholipids y ∧ Proteins z ∧ Have x y ∧ Have x z"

(* Explanation 2: Proteins are sometimes coats of a virus. *)
axiomatization where
  explanation_2: "∃x y. Proteins x ∧ Viruses y ∧ Coats x y"  

theorem hypothesis:
  assumes asm: "Viruses x"
  (* Hypothesis: Some viruses have a coating of phospholipids. *)
  shows "∃x y. Viruses x ∧ Phospholipids y ∧ Have x y"
proof -
  obtain y z where "Phospholipids y ∧ Proteins z ∧ Have x y ∧ Have x z" using explanation_1 by auto
  then have "Phospholipids y ∧ Have x y" by simp
  then show ?thesis using asm by blast
qed

end
