theory question_99_1
imports Main
begin

typedecl entity
typedecl event

consts
  VegetableOil :: "entity ⇒ bool"
  RenewableResource :: "entity ⇒ bool"
  Fuel :: "entity ⇒ bool"
  DieselEngine :: "entity ⇒ bool"
  Burn :: "event ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: vegetable oil is a renewable resource. *)
axiomatization where
  explanation_1: "∀x y. VegetableOil x ⟶ RenewableResource y"

(* Explanation 2: vegetable oil is a kind of fuel. *)
axiomatization where
  explanation_2: "∀x y. VegetableOil x ⟶ Fuel y"

theorem hypothesis:
  (* Premise: Diesel engines can burn many kinds of fuel. *)
  assumes asm: "DieselEngine x ∧ Fuel y ∧ Burn e x y"
  (* Hypothesis: Organically produced vegetable oil is the most renewable fuel for a diesel engine. *)
  shows "∃x y z e. OrganicallyProducedVegetableOil x ∧ RenewableResource y ∧ Fuel z ∧ DieselEngine e ∧ IsMostRenewableFuelFor x z e"
proof -
  from asm have "Fuel y" using explanation_2 by blast
  then have "RenewableResource y" using explanation_1 by blast
  then obtain x where x: "OrganicallyProducedVegetableOil x" by blast
  have conclusion: "Fuel y ∧ RenewableResource y" using `Fuel y` `RenewableResource y` by blast
  show ?thesis using x conclusion asm by blast
qed

end
