theory question_89_4

imports Main

begin

typedecl entity
typedecl event

consts
  Muscles :: "entity ⇒ bool"
  Contract :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Triceps :: "entity ⇒ bool"

(* Explanation 1: Muscles can only contract. *)
axiomatization where
  explanation_1: "∀x e. Muscles x ∧ Contract e ∧ Agent e x"

theorem hypothesis:
  assumes asm: "Triceps x"
  (* Hypothesis: Triceps can only contract. *)
  shows "∃e. Triceps x ∧ Contract e ∧ Agent e x"
proof -
  from asm have "Triceps x" by simp
  then have "Muscles x" using explanation_3 by blast
  then obtain e where e: "Contract e ∧ Agent e x" using explanation_1 by blast
  then have "Triceps x ∧ Contract e ∧ Agent e x" using asm e by blast
  then show ?thesis by blast
qed

end
