theory question_85_6
imports Main

begin

typedecl entity
typedecl event

consts
  PacinianCorpuscles :: "entity ⇒ bool"
  PressureReceptors :: "entity ⇒ bool"
  Skin :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Location :: "event ⇒ entity ⇒ entity ⇒ bool"
  Mainly :: "event ⇒ bool"

(* Explanation 1: Pacinian corpuscles, as pressure receptors, are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x y. PacinianCorpuscles x ∧ PressureReceptors x ∧ Skin y ⟶ (∃e. Found e ∧ Location e x y ∧ Mainly e)"

(* Explanation 2: Pacinian corpuscles, as pressure receptors, suggest their function in detecting pressure stimuli. *)
axiomatization where
  explanation_2: "∀x y z e. PacinianCorpuscles x ∧ PressureReceptors x ∧ Function z ∧ Detecting e ∧ Stimuli e z ∧ Suggest e ∧ Implication e x z"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x ∧ Skin y"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "∃e. Found e ∧ Location e x y ∧ Mainly e"
proof -
  from asm have "PacinianCorpuscles x ∧ Skin y" by simp
  then obtain e where e: "Found e ∧ Location e x y ∧ Mainly e" using explanation_1 by blast
  then have "PressureReceptors x" using explanation_1 by blast
  then have "Function z ∧ Detecting e ∧ Stimuli e z ∧ Suggest e ∧ Implication e x z" using explanation_2 by blast
  have conclusion: "Found e ∧ Location e x y ∧ Mainly e" using e by simp
  show ?thesis using conclusion by blast
qed

end
