theory question_4_2

imports Main

begin

typedecl entity
typedecl event

consts
  Ancathostega :: "entity ⇒ bool"
  EarliestTetrapodsFound :: "entity ⇒ bool"
  MostComplete :: "entity ⇒ bool"
  Limbs :: "entity ⇒ bool"
  Possesses :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Ancathostega is one of the earliest tetrapods found, and by far the most complete. *)
axiomatization where
  explanation_1: "∀x. Ancathostega x ⟶ (EarliestTetrapodsFound x ∧ MostComplete x)"

(* Explanation 2: Ancathostega possesses four limbs. *)
axiomatization where
  explanation_2: "∀x y. Ancathostega x ∧ Limbs y ∧ Possesses y x"

theorem hypothesis:
  assumes asm: "Ancathostega x"
  (* Hypothesis: Ancathostega have four limbs. *)
  shows "∃x y. Ancathostega x ∧ Limbs y ∧ Possesses y x"
proof -
  from asm have "Ancathostega x" by simp
  then have "EarliestTetrapodsFound x ∧ MostComplete x" using explanation_1 by blast
  then obtain y where y: "Limbs y ∧ Possesses y x" using explanation_2 by blast
  have conclusion: "EarliestTetrapodsFound x ∧ MostComplete x" using `Ancathostega x` by simp
  show ?thesis using conclusion y by blast
qed

end
