theory question_20_1
imports Main
begin

typedecl entity
typedecl event

consts
  Hair :: "entity ⇒ bool"
  Fiber :: "entity ⇒ bool"
  FoundIn :: "entity ⇒ entity ⇒ bool"
  Mammals :: "entity ⇒ bool"
  Fur :: "entity ⇒ bool"
  ExclusiveCharacteristic :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Hair is a fiber that is found only in mammals. *)
axiomatization where
  explanation_1: "∀x. Hair x ⟶ Fiber x ∧ (∃y. FoundIn x y ∧ Mammals y)"

(* Explanation 2: All mammals have fur or hair. *)
axiomatization where
  explanation_2: "∀x. Mammals x ⟶ (Fur x ∨ Hair x)"

(* Explanation 3: Fur is a characteristic exclusive to mammals. *)
axiomatization where
  explanation_3: "∀x. Fur x ⟶ (∃y. ExclusiveCharacteristic x y ∧ Mammals y)"

theorem hypothesis:
  assumes asm: "Fur x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "UniqueToMammals x"
proof -
  from asm have "Fur x" by simp
  then obtain y where y: "ExclusiveCharacteristic x y ∧ Mammals y" using explanation_3 by blast
  then have "Mammals y" using explanation_2 by blast
  have conclusion: "ExclusiveCharacteristic x y ∧ Mammals y" using y `Mammals y` by simp
  show ?thesis using conclusion by blast
qed

end
