theory question_42_0
imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  Park :: "entity ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"
  People :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  ParkBench :: "entity ⇒ bool"
  Newlyweds :: "entity ⇒ bool"
  Behind :: "entity ⇒ entity ⇒ bool"
  Sit :: "entity ⇒ bool"

(* Explanation 1: A MAN AND WOMAN ARE AT THE PARK *)
axiomatization where
  explanation_1: "∃x y. Man x ∧ Woman y ∧ Park x ∧ At x y"

theorem hypothesis:
  (* Premise: A man and woman sit on a park bench with a set of newlyweds behind. *)
  assumes asm: "Man x ∧ Woman y ∧ ParkBench z ∧ Newlyweds e ∧ Behind e z ∧ Sit e ∧ At x z"
  (* Hypothesis: People outside. *)
  shows "∃x. People x ∧ Outside x"
proof -
  from asm have "Man x ∧ Woman y ∧ Park x ∧ At x y" by blast
  then have "People x ∧ Outside x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
