theory question_27_3

imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  DirtySidewalk :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Old :: "entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Location :: "event ⇒ entity ⇒ bool"

(* Explanation 1: If a man is on a dirty sidewalk, then he is outside. *)
axiomatization where
  explanation_1: "∀x y. Man x ∧ DirtySidewalk y ⟶ Outside x"

theorem hypothesis:
  (* Premise: An old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "Old x ∧ Man x ∧ HardwareParts y ∧ DirtySidewalk z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ Location e z"
  (* Hypothesis: The man is outside. *)
  shows "∃x. Man x ∧ Outside x"
proof -
  from asm have "Old x ∧ Man x ∧ DirtySidewalk z" by blast
  then have "Man x ∧ DirtySidewalk z" by blast
  then have "Outside x" using explanation_1 by blast
  then show ?thesis using `Man x` by blast
qed

end
