###############
# Supplementary code
# Paper: Nauman Dawalatabad, Yuan Gong, Sameer Khurana, Rhoda Au, James Glass, "Detecting Dementia from Long Neuropsychological Interviews", Findings of the Association for Computational Linguistics: EMNLP 2021.
##############

list=$1 

corpus_directory=fhs/
wav_soft_link_dir=/path/to/wav/ 
tg_dir=/path/to/textgrid/

mkdir -p $corpus_directory
while read -r x;
do
	cp -P $wav_soft_link_dir/$x.wav   $corpus_directory/
	cp $tg_dir/$x.TextGrid  $corpus_directory/
done < $list


# Some paths
dict_path=pretrained_models_downloaded/dictionary/english.dict
acoustic_model_path=/adapted/model/path/
output_path=/path/to/store/final/alignments/
tmp_dir=/path/to/temp/files/

# ALIGN
# Syntax: mfa align corpus_directory dictionary_path acoustic_model_path output_directory
mfa align \
	-j 32 \
	-t $tmp_dir \
	--clean \
	--overwrite \
	$corpus_directory \
	$dict_path \
	$acoustic_model_path \
	$output_path
