import argparse

import init

parser = argparse.ArgumentParser(description="Get a list of assignments for a given HIT")
parser.add_argument('-s', '--sandbox', help='Do on the sandbox', action='store_true')
parser.add_argument('--hits', help='HITs to approve', nargs="+", default=[])
args = parser.parse_args()

client = init.get_client(args.sandbox)

for hit in args.hits:
    response = client.list_assignments_for_hit(
        HITId=hit,
        MaxResults=100,
        AssignmentStatuses=[
            'Submitted',
        ]
    )

    for assignment in response['Assignments']:
        print(assignment['AssignmentId'], 'done by', assignment['WorkerId'], 'for', hit, 'currently', assignment['AssignmentStatus'])
