import argparse
import init

parser = argparse.ArgumentParser(description="Delete all of your remaining HITs, so they don't show up when you are querying MTurk.")
parser.add_argument('-s', '--sandbox', help='Do on the sandbox', action='store_true')
parser.add_argument('--hits', help='HITs to delete', nargs="+", default=[])
args = parser.parse_args()

client = init.get_client(args.sandbox)

hits = client.list_hits(MaxResults=100)
for hit in hits['HITs']:
    if len(args.hits) > 0 and hit['HITId'] not in args.hits:
        continue
    print("Deleting", hit['HITId'])
    response = client.delete_hit(
        HITId=hit['HITId'],
    )
    print(response)
