/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.realiser.CoordinatePhrase;
import simplenlg.realiser.CoordinatePhraseSet;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.VPPhraseSpec;

public class CoordinateVPPhraseSpec
extends VPPhraseSpec
implements CoordinatePhrase<VPPhraseSpec> {
    private CoordinatePhraseSet<VPPhraseSpec> coordinator;
    private boolean aggregateAuxiliary = false;

    public CoordinateVPPhraseSpec(VPPhraseSpec ... coords) {
        this.coordinator = new CoordinatePhraseSet((Phrase)this, (Phrase[])coords);
    }

    @Override
    public void setConjunction(Conjunction coord) {
        this.coordinator.setConjunction(coord);
    }

    @Override
    public void setConjunction(String coord) {
        this.coordinator.setConjunction(coord);
    }

    @Override
    public Conjunction getConjunction() {
        return this.coordinator.getConjunction();
    }

    @Override
    public String getConjunctionAsString() {
        return this.coordinator.getConjunctionAsString();
    }

    public void addCoordinates(VPPhraseSpec ... coords) {
        this.coordinator.addCoordinates(coords);
    }

    public void setCoordinates(VPPhraseSpec ... coords) {
        this.coordinator.clearCoordinates();
        this.addCoordinates(coords);
    }

    @Override
    public List<VPPhraseSpec> getCoordinates() {
        return this.coordinator.getCoordinates();
    }

    public void aggregateAuxiliary(boolean aggr) {
        this.aggregateAuxiliary = aggr;
        for (VPPhraseSpec child : this.coordinator.getCoordinates()) {
            child.realiseAuxiliary(false);
        }
    }

    @Override
    public void setForm(Form f) {
        super.setForm(f);
        for (VPPhraseSpec child : this.coordinator.coordinates) {
            child.setForm(f);
        }
    }

    @Override
    public void setPassive(boolean pass) {
        super.setPassive(pass);
        for (VPPhraseSpec child : this.coordinator.coordinates) {
            child.setPassive(pass);
        }
    }

    @Override
    public void setProgressive(boolean prog) {
        super.setProgressive(prog);
        for (VPPhraseSpec child : this.coordinator.coordinates) {
            child.setProgressive(prog);
        }
    }

    @Override
    public void setPerfect(boolean perf) {
        super.setPerfect(perf);
        for (VPPhraseSpec child : this.coordinator.coordinates) {
            child.setPerfect(perf);
        }
    }

    @Override
    public void setNegated(boolean neg) {
        super.setNegated(true);
        for (VPPhraseSpec child : this.coordinator.coordinates) {
            child.setNegated(neg);
        }
    }

    @Override
    public void setTense(Tense t) {
        super.setTense(t);
        for (VPPhraseSpec child : this.coordinator.coordinates) {
            child.setTense(t);
        }
    }

    @Override
    public void setModal(String modal) {
        super.setModal(modal);
        for (VPPhraseSpec child : this.coordinator.coordinates) {
            child.setModal(modal);
        }
    }

    @Override
    public void setPerson(Person p) {
        super.setPerson(p);
        for (VPPhraseSpec child : this.coordinator.coordinates) {
            child.setPerson(p);
        }
    }

    @Override
    public void setNumber(NumberAgr n) {
        super.setNumber(n);
        for (VPPhraseSpec child : this.coordinator.coordinates) {
            child.setNumber(n);
        }
    }

    @Override
    public List<Phrase> getComplements(DiscourseFunction function) {
        List<Phrase> comps = super.getComplements(function);
        for (VPPhraseSpec child : this.coordinator.getCoordinates()) {
            comps.addAll(child.getComplements(function));
        }
        return comps;
    }

    @Override
    String realise(Realiser r, boolean subordinate) {
        if (this.aggregateAuxiliary) {
            this.realiseVerbGroup(r, subordinate);
            this.computeRealisation(r, subordinate);
        }
        String preModText = this.realisePremodifier(r);
        String compText = this.realiseComplement(r);
        String postModText = this.realisePostmodifier(r);
        String coordText = this.coordinator.realise(r);
        return r.appendSpace(preModText, this.auxiliaryRealisation, coordText, compText, postModText);
    }

    @Override
    String realise(Realiser r) {
        return this.realise(r, false);
    }

    @Override
    public List<Phrase> getPassiveRaisingComplements() {
        List<Phrase> objects = this.getComplements(DiscourseFunction.OBJECT);
        if (objects.isEmpty()) {
            for (Phrase p : this.getComplements(DiscourseFunction.INDIRECT_OBJECT)) {
                if (p instanceof PPPhraseSpec && !p.isElided()) {
                    objects.addAll(((PPPhraseSpec)p).getComplements());
                    continue;
                }
                if (p.isElided()) continue;
                objects.add(p);
            }
        }
        return this.flagRaisedNPs(objects, true);
    }
}

