
(* #load "str.cmxa";; *)
(* #load "scripts/trees.ml";; *)

open Str
open String
open Trees


(* formatting exception *)
exception WrongFormat of string;;


(* Replace rare categories *)
let rec expand_mod_relns = function
    End,_ -> End
  | ChildList(Term(s),cl),cP when string_match (regexp "^\\(.*\\):\\(.*\\)\\({.*\\)$") s 0 ->
      let l = matched_group 1 s in
      let c = matched_group 2 s in
      let r = matched_group 3 s in
      (* ChildList(Term((if l="m" then l^cP^">"^c else l)^":"^c^r), *)
      ChildList(Term((if l="m" then l^c else l)^":"^c^r),
                expand_mod_relns(cl,if (String.contains c '_') then cP else c))
  | ChildList(cl1,cl2),cP ->
      ChildList(expand_mod_relns(cl1,cP),expand_mod_relns(cl2,cP))
  | Term(s),cP when string_match (regexp "\\(.*\\)#\\(.*\\)") s 0 ->
      Term(s)
  | Term(s),_ -> raise (WrongFormat s);;


(* read loop *)
try
  while true do
    let s = input_line stdin in     (* "(S (NP the cat) (VP sat down))" in *)
    let r,t = tree_of_string s in
    print_endline(string_of_tree(expand_mod_relns(t,"REST")))
  done;
  None
with
  End_of_file -> None
;;



