///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"

char psX[]   = "";
char psSpc[] = " ";

char psLBrace[]="{";
char psRBrace[]="}";
char psColon[]=":";

//// C: syntactic symbol
DiscreteDomain<int> domC;
typedef DiscreteDomainRV<int,domC> C;
const C C_BOT ("-");
const C C_TOP ("REST");

//// L: relation symbol
DiscreteDomain<int> domL;
typedef DiscreteDomainRV<int,domL> L;
const L L_BOT ("-");
const L L_TOP ("h");

//// E: headword/referent symbol
DiscreteDomain<int> domE;
typedef DiscreteDomainRV<int,domE> E;
const E E_BOT ("-");
const E E_TOP ("-");
const E E_UNK ("unk");

//// CC: helper model -- child constituents
typedef DelimitedJoint2DRV<psX,C,psSpc,C,psX> CC;
//const CC CC_TOP (C_TOP,C_TOP);

//// LC: rel-annotated syntax
typedef DelimitedJoint2DRV<psX,L,psColon,C,psX> LC;
const LC LC_TOP (L_TOP,C_TOP);

//// LCLC: child rel-annotated syntax
typedef DelimitedJoint2DRV<psX,LC,psSpc,LC,psX> LCLC;

//// G: grammar rule symbol = CE
//typedef DelimitedJoint2DRV<psX,C,psLBrace,E,psRBrace> G;
class G : public DelimitedJoint2DRV<psX,C,psLBrace,E,psRBrace> {
 public:
  G ( )                       : DelimitedJoint2DRV<psX,C,psLBrace,E,psRBrace>()      { }
  G ( const C& c, const E& e) : DelimitedJoint2DRV<psX,C,psLBrace,E,psRBrace>(c,e) { }
  int toInt ( ) const { return this->first.toInt()*E::getDomain().getSize() + this->second.toInt(); }
};
const G G_BOT (C_BOT,E_BOT);
const G G_TOP (C_TOP,E_TOP);

//// GG: pair of grammar rule symbols associated with rule expansion
typedef DelimitedJoint2DRV<psX,G,psSpc,G,psX> GG;
const GG GG_BOT ( G_BOT, G_BOT );

//// HW: real headwords vs. unk
DiscreteDomain<int> domHW;
typedef DiscreteDomainRV<int,domHW> HW;
const HW HW_UNK ("unk");


//// HW headword model
typedef CPT1DModel<HW,LogProb> HWModel;

//// M Syntax Model, LC LC given G=CE... STORED AS PROB, not LogProb
typedef CPT2DModel<LCLC,G,Prob> MModel;
//// L Semantics Model, E given L E... STORED AS PROB, not LogProb
typedef CPT3DModel<E,L,E,Prob> LModel;

//// Model of C (prior)
typedef CPT1DModel<C,LogProb> CModel;
//// Model of G (prior)
typedef CPT1DModel<G,LogProb> GModel;
//// Model of G given G (unary branching expansion)
typedef CPT2DModel<G,G,LogProb> GuModel;



//// Model of GG given G (binary branching expansion)... STORED AS PROB, not LogProb
typedef CPT2DModel<GG,G,Prob> GGModel;


