/*
 * Decompiled with CFR 0.152.
 */
package main.phrases;

import babel.content.corpora.accessors.CorpusAccessor;
import babel.content.corpora.accessors.CrawlCorpusAccessor;
import babel.content.corpora.accessors.EuroParlCorpusAccessor;
import babel.content.corpora.accessors.LexCorpusAccessor;
import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.SimpleEquivalenceClass;
import babel.content.eqclasses.collectors.EquivalenceClassCollector;
import babel.content.eqclasses.collectors.SimpleEquivalenceClassCollector;
import babel.content.eqclasses.comparators.LexComparator;
import babel.content.eqclasses.filters.DictionaryFilter;
import babel.content.eqclasses.filters.EquivalenceClassFilter;
import babel.content.eqclasses.filters.GarbageFilter;
import babel.content.eqclasses.filters.LengthFilter;
import babel.content.eqclasses.filters.NumOccurencesFilter;
import babel.content.eqclasses.filters.RomanizationFilter;
import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.phrases.PhraseSet;
import babel.content.eqclasses.phrases.PhraseTable;
import babel.content.eqclasses.properties.context.PhraseContextCollector;
import babel.content.eqclasses.properties.lshcontext.LSHContextCollector;
import babel.content.eqclasses.properties.lshtime.LSHTimeDistributionCollector;
import babel.content.eqclasses.properties.number.Number;
import babel.content.eqclasses.properties.number.NumberCollector;
import babel.content.eqclasses.properties.number.PhraseNumberCollector;
import babel.content.eqclasses.properties.time.PhraseTimeDistributionCollector;
import babel.content.eqclasses.properties.time.TimeDistribution;
import babel.content.eqclasses.properties.type.Type;
import babel.ranking.scorers.Scorer;
import babel.util.config.Configurator;
import babel.util.dict.Dictionary;
import babel.util.dict.SimpleDictionary;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AllPairsTokenPreparer {
    protected static final Log LOG = LogFactory.getLog(AllPairsTokenPreparer.class);
    protected Set<Phrase> m_srcPhrs = null;
    protected Set<Phrase> m_trgPhrs = null;
    protected long m_maxTokCountInSrc = 0L;
    protected long m_maxTokCountInTrg = 0L;
    protected Dictionary m_seedDict = null;
    protected SimpleDictionary m_translitDict = null;
    protected Set<EquivalenceClass> m_contextSrcEqs = null;
    protected Set<EquivalenceClass> m_contextTrgEqs = null;
    protected List<Phrase> m_srcPhrasesToProcess = null;

    public Dictionary getSeedDict() {
        return this.m_seedDict;
    }

    public SimpleDictionary getTranslitDict() {
        return this.m_translitDict;
    }

    public long getMaxSrcTokCount() {
        return this.m_maxTokCountInSrc;
    }

    public long getMaxTrgTokCount() {
        return this.m_maxTokCountInTrg;
    }

    public Set<Phrase> getSrcPhrases() {
        return this.m_srcPhrs;
    }

    public Set<Phrase> getTrgPhrases() {
        return this.m_trgPhrs;
    }

    public void prepareForFeaturesCollection() throws Exception {
        LOG.info((Object)" - Preparing phrases for estimating monolingual features ...");
        this.readPhrases();
        this.collectNumberProps(this.m_srcPhrs, this.m_trgPhrs, true);
        this.collectTypeProp(this.m_srcPhrs, this.m_trgPhrs);
        this.collectContextEqs();
        this.prepareSeedDictionary(this.m_contextSrcEqs, this.m_contextTrgEqs);
        this.prepareTranslitDictionary(this.m_contextSrcEqs);
        this.filterContextEqs();
        this.m_srcPhrasesToProcess = new ArrayList<Phrase>(this.m_srcPhrs);
        Collections.sort(this.m_srcPhrasesToProcess, new LexComparator(true));
    }

    public PhraseTable getNextChunkToProcess(int chunkSrcSize) {
        boolean caseSensitive = Configurator.CONFIG.getBoolean("preprocessing.phrases.CaseSensitive");
        int toIdx = Math.min(chunkSrcSize, this.m_srcPhrasesToProcess.size());
        PhraseTable phTable = null;
        if (toIdx > 0) {
            HashSet<Phrase> srcSet = new HashSet<Phrase>((Collection)this.m_srcPhrasesToProcess.subList(0, toIdx));
            this.m_srcPhrasesToProcess.removeAll(srcSet);
            phTable = new PhraseTable(srcSet, this.m_trgPhrs, caseSensitive);
        }
        return phTable;
    }

    public void collectContextAndTimeProps(Set<Phrase> srcPhrases, Set<Phrase> trgPhrases) throws Exception {
        LOG.info((Object)(" - Collecting context and time phrase properties for " + srcPhrases.size() + " source and " + trgPhrases.size() + " target phrases " + " ..."));
        int maxPhraseLength = Configurator.CONFIG.getInt("preprocessing.phrases.MaxPhraseLength");
        boolean caseSensitive = Configurator.CONFIG.getBoolean("preprocessing.phrases.CaseSensitive");
        int contextWindowSize = Configurator.CONFIG.getInt("preprocessing.context.Window");
        boolean alignDistros = Configurator.CONFIG.getBoolean("preprocessing.time.Align");
        Set<Integer> srcBins = this.collectContextAndTimeProps(true, srcPhrases, maxPhraseLength, this.m_contextSrcEqs, contextWindowSize, caseSensitive);
        Set<Integer> trgBins = this.collectContextAndTimeProps(false, trgPhrases, maxPhraseLength, this.m_contextTrgEqs, contextWindowSize, caseSensitive);
        if (alignDistros) {
            LOG.info((Object)" - Aligning temporal distributions...");
            this.alignDistributions(srcBins, trgBins, srcPhrases, trgPhrases);
        }
    }

    public void prepareContextAndTimeProps(boolean src, Set<? extends EquivalenceClass> eqs, Scorer contextScorer, Scorer timeScorer, boolean mapToLSH) throws Exception {
        LOG.info((Object)(" - " + (src ? "Scoring source" : "Projecting and scoring target") + " contextual items with " + contextScorer.toString() + " and time distributions with " + timeScorer.toString() + "..."));
        for (EquivalenceClass equivalenceClass : eqs) {
            contextScorer.prepare(equivalenceClass);
            timeScorer.prepare(equivalenceClass);
        }
        if (mapToLSH) {
            LOG.info((Object)(" - Mapping " + (src ? "source" : "target") + " context into LSH space..."));
            new LSHContextCollector(true).collectProperty(eqs);
            LOG.info((Object)(" - Mapping " + (src ? "source" : "target") + " temporal into LSH space..."));
            new LSHTimeDistributionCollector(true).collectProperty(eqs);
        }
    }

    protected void alignDistributions(Set<Integer> srcBins, Set<Integer> trgBins, Set<Phrase> srcEqs, Set<Phrase> trgEqs) {
        TimeDistribution timeProp;
        HashSet<Integer> toRemove = new HashSet<Integer>(srcBins);
        toRemove.removeAll(trgBins);
        for (EquivalenceClass equivalenceClass : srcEqs) {
            timeProp = (TimeDistribution)equivalenceClass.getProperty(TimeDistribution.class.getName());
            if (timeProp == null) continue;
            timeProp.removeBins(toRemove);
        }
        toRemove.clear();
        toRemove.addAll(trgBins);
        toRemove.removeAll(srcBins);
        for (EquivalenceClass equivalenceClass : trgEqs) {
            timeProp = (TimeDistribution)equivalenceClass.getProperty(TimeDistribution.class.getName());
            if (timeProp == null) continue;
            timeProp.removeBins(toRemove);
        }
        toRemove.clear();
        toRemove.addAll(srcBins);
        toRemove.retainAll(trgBins);
        LOG.info((Object)("There are " + srcBins.size() + " days in src distributions."));
        LOG.info((Object)("There are " + trgBins.size() + " days in trg distributions."));
        LOG.info((Object)("There are " + toRemove.size() + " common days between src and trg distributions."));
    }

    protected Set<Integer> collectContextAndTimeProps(boolean src, Set<Phrase> phrases, int maxPhraseLength, Set<EquivalenceClass> contextEqs, int contextWindowSize, boolean caseSensitive) throws Exception {
        CorpusAccessor accessor = this.getAccessor(Configurator.CONFIG.getString("preprocessing.input.Context"), src);
        new PhraseContextCollector(maxPhraseLength, caseSensitive, contextWindowSize, contextWindowSize, contextEqs).collectProperty(accessor, phrases);
        accessor = this.getAccessor(Configurator.CONFIG.getString("preprocessing.input.Time"), src);
        PhraseTimeDistributionCollector distCollector = new PhraseTimeDistributionCollector(maxPhraseLength, caseSensitive);
        distCollector.collectProperty(accessor, phrases);
        return distCollector.binsCollected();
    }

    protected void prepareSeedDictionary(Set<EquivalenceClass> srcContEqs, Set<EquivalenceClass> trgContEqs) throws Exception {
        SimpleDictionary simpSeedDict;
        String dictDir = Configurator.CONFIG.getString("resources.dictionary.Path");
        int ridDictNumTrans = Configurator.CONFIG.containsKey("experiments.DictionaryPruneNumTranslations") ? Configurator.CONFIG.getInt("experiments.DictionaryPruneNumTranslations") : -1;
        LOG.info((Object)" - Reading/preparing seed dictionary ...");
        if (Configurator.CONFIG.containsKey("resources.dictionary.Dictionary")) {
            String dictFileName = Configurator.CONFIG.getString("resources.dictionary.Dictionary");
            simpSeedDict = new SimpleDictionary(String.valueOf(dictDir) + dictFileName, "SeedDictionary");
        } else {
            String srcDictFileName = Configurator.CONFIG.getString("resources.dictionary.SrcName");
            String trgDictFileName = Configurator.CONFIG.getString("resources.dictionary.TrgName");
            simpSeedDict = new SimpleDictionary(new SimpleDictionary.DictHalves(String.valueOf(dictDir) + srcDictFileName, String.valueOf(dictDir) + trgDictFileName), "SeedDictionary");
        }
        simpSeedDict.pruneCounts(ridDictNumTrans);
        this.m_seedDict = new Dictionary(srcContEqs, trgContEqs, simpSeedDict, "SeedDictionary");
        LOG.info((Object)(" - Seed dictionary: " + this.m_seedDict.toString()));
    }

    protected void prepareTranslitDictionary(Set<EquivalenceClass> srcContEqs) throws Exception {
        String dictDir;
        LOG.info((Object)" - Reading/preparing transliteration dictionary ...");
        String string = dictDir = Configurator.CONFIG.containsKey("resources.translit.Path") ? Configurator.CONFIG.getString("resources.translit.Path") : null;
        if (dictDir == null || dictDir.trim().length() == 0) {
            LOG.info((Object)" - No transliteration dictionary specified");
        } else {
            if (Configurator.CONFIG.containsKey("resources.translit.Dictionary")) {
                String dictFileName = Configurator.CONFIG.getString("resources.translit.Dictionary");
                this.m_translitDict = new SimpleDictionary(String.valueOf(dictDir) + dictFileName, "Translit");
            } else {
                String srcDictFileName = Configurator.CONFIG.getString("resources.translit.SrcName");
                String trgDictFileName = Configurator.CONFIG.getString("resources.translit.TrgName");
                this.m_translitDict = new SimpleDictionary(new SimpleDictionary.DictHalves(String.valueOf(dictDir) + srcDictFileName, String.valueOf(dictDir) + trgDictFileName), "TranslitDictionary");
            }
            LOG.info((Object)(" - Transliteration dictionary: " + this.m_translitDict.toString()));
        }
    }

    protected void collectContextEqs() throws Exception {
        LOG.info((Object)" - Constructing contextual equivalence classes...");
        boolean filterRomanSrc = Configurator.CONFIG.containsKey("preprocessing.FilterRomanSrc") && Configurator.CONFIG.getBoolean("preprocessing.FilterRomanSrc");
        boolean filterRomanTrg = Configurator.CONFIG.containsKey("preprocessing.FilterRomanTrg") && Configurator.CONFIG.getBoolean("preprocessing.FilterRomanTrg");
        Class<EquivalenceClass> srcContClassClass = Class.forName(Configurator.CONFIG.getString("preprocessing.context.SrcEqClass"));
        Class<EquivalenceClass> trgContClassClass = Class.forName(Configurator.CONFIG.getString("preprocessing.context.TrgEqClass"));
        this.m_contextSrcEqs = this.collectContextEqs(true, true, filterRomanSrc, srcContClassClass);
        this.m_contextTrgEqs = this.collectContextEqs(false, true, filterRomanTrg, trgContClassClass);
        this.m_maxTokCountInSrc = this.collectMaxOccurrenceCount(this.m_contextSrcEqs);
        this.m_maxTokCountInTrg = this.collectMaxOccurrenceCount(this.m_contextTrgEqs);
        LOG.info((Object)(" - Source context classes = " + this.m_contextSrcEqs.size() + ", max occurrences = " + this.m_maxTokCountInSrc));
        LOG.info((Object)(" - Target context classes = " + this.m_contextTrgEqs.size() + ", max occurrences = " + this.m_maxTokCountInTrg));
    }

    protected Set<EquivalenceClass> collectContextEqs(boolean src, boolean caseSensitive, boolean filterRoman, Class<EquivalenceClass> contextClassClass) throws Exception {
        ArrayList<EquivalenceClassFilter> filters = new ArrayList<EquivalenceClassFilter>(3);
        filters.add(new GarbageFilter());
        filters.add(new LengthFilter(2));
        if (filterRoman) {
            filters.add(new RomanizationFilter());
        }
        CorpusAccessor accessor = this.getAccessor(Configurator.CONFIG.getString("preprocessing.input.Context"), src);
        SimpleEquivalenceClassCollector collector = new SimpleEquivalenceClassCollector(filters, caseSensitive);
        Set<EquivalenceClass> eqs = collector.collect(accessor.getCorpusReader(), -1);
        new NumberCollector(caseSensitive).collectProperty(accessor, eqs);
        eqs = this.constructEqClasses(src, eqs, contextClassClass);
        this.assignTypeProp(eqs, src ? Type.EqType.SOURCE : Type.EqType.TARGET);
        return eqs;
    }

    protected Set<EquivalenceClass> constructEqClasses(boolean src, Set<EquivalenceClass> allEqs, Class<? extends EquivalenceClass> eqClassClass) throws Exception {
        HashMap<String, EquivalenceClass> eqsMap = new HashMap<String, EquivalenceClass>();
        for (EquivalenceClass eq : allEqs) {
            String newWord = ((SimpleEquivalenceClass)eq).getWord();
            long newCount = ((Number)eq.getProperty(Number.class.getName())).getNumber();
            EquivalenceClass newEq = eqClassClass.newInstance();
            newEq.init(newWord, true);
            EquivalenceClass foundEq = (EquivalenceClass)eqsMap.get(newEq.getStem());
            if (foundEq == null) {
                newEq.assignId();
                newEq.setProperty(new Number(newCount));
                newEq.setProperty(new Type(src ? Type.EqType.SOURCE : Type.EqType.TARGET));
                eqsMap.put(newEq.getStem(), newEq);
                continue;
            }
            foundEq.merge(newEq);
            ((Number)foundEq.getProperty(Number.class.getName())).increment(newCount);
        }
        return new HashSet<EquivalenceClass>(eqsMap.values());
    }

    protected void filterContextEqs() throws Exception {
        int pruneContEqIfOccursFewerThan = Configurator.CONFIG.getInt("preprocessing.context.PruneEqIfOccursFewerThan");
        int pruneContEqIfOccursMoreThan = Configurator.CONFIG.getInt("preprocessing.context.PruneEqIfOccursMoreThan");
        this.m_contextSrcEqs = this.filterContextEqs(true, this.m_contextSrcEqs, pruneContEqIfOccursFewerThan, pruneContEqIfOccursMoreThan);
        this.m_contextTrgEqs = this.filterContextEqs(false, this.m_contextTrgEqs, pruneContEqIfOccursFewerThan, pruneContEqIfOccursMoreThan);
    }

    protected Set<EquivalenceClass> filterContextEqs(boolean src, Set<EquivalenceClass> eqs, int pruneContEqIfOccursFewerThan, int pruneContEqIfOccursMoreThan) throws Exception {
        LOG.info((Object)(" - Filtering " + (src ? "source" : "target") + " contextual words: keeping those in dict [" + this.m_seedDict.toString() + "] and occuring (" + pruneContEqIfOccursFewerThan + "," + pruneContEqIfOccursMoreThan + ") times..."));
        LinkedList<EquivalenceClassFilter> filters = new LinkedList<EquivalenceClassFilter>();
        filters.add(new DictionaryFilter(this.m_seedDict, true, src));
        filters.add(new NumOccurencesFilter(pruneContEqIfOccursFewerThan, true));
        filters.add(new NumOccurencesFilter(pruneContEqIfOccursMoreThan, false));
        Set<EquivalenceClass> filtContextEqs = EquivalenceClassCollector.filter(eqs, filters);
        LOG.info((Object)(" - Filtered context " + (src ? "source" : "target") + " classes: " + filtContextEqs.size()));
        return filtContextEqs;
    }

    protected void readPhrases() throws Exception {
        boolean caseSensitive = Configurator.CONFIG.getBoolean("preprocessing.phrases.CaseSensitive");
        String srcPhraseFile = Configurator.CONFIG.getString("resources.phrases.SrcPhraseFile");
        String trgPhraseFile = Configurator.CONFIG.getString("resources.phrases.TrgPhraseFile");
        LOG.info((Object)(" - Reading candidate src phrases from " + srcPhraseFile + " ..."));
        this.m_srcPhrs = new PhraseSet(srcPhraseFile, caseSensitive, 1).getPhrases();
        LOG.info((Object)(" - Reading candidate trg phrases from " + trgPhraseFile + " ..."));
        this.m_trgPhrs = new PhraseSet(trgPhraseFile, caseSensitive, 1).getPhrases();
        LOG.info((Object)(" - Source phrases: " + this.m_srcPhrs.size()));
        LOG.info((Object)(" - Target phrases: " + this.m_trgPhrs.size()));
    }

    protected void collectNumberProps(Set<Phrase> srcPhrs, Set<Phrase> trgPhrs, boolean verbose) throws Exception {
        LOG.info((Object)" - Collecting phrase counts...");
        int maxPhraseLength = Configurator.CONFIG.getInt("preprocessing.phrases.MaxPhraseLength");
        boolean caseSensitive = Configurator.CONFIG.getBoolean("preprocessing.phrases.CaseSensitive");
        this.collectNumberProps(true, srcPhrs, maxPhraseLength, caseSensitive);
        this.collectNumberProps(false, trgPhrs, maxPhraseLength, caseSensitive);
    }

    protected void collectNumberProps(boolean src, Set<Phrase> phrases, int maxPhraseLength, boolean caseSensitive) throws Exception {
        CorpusAccessor accessor = this.getAccessor(Configurator.CONFIG.getString("preprocessing.input.Context"), src);
        new PhraseNumberCollector(maxPhraseLength, caseSensitive).collectProperty(accessor, phrases);
    }

    protected long collectMaxOccurrenceCount(Set<? extends EquivalenceClass> eqs) {
        long maxOccurCount = 0L;
        for (EquivalenceClass equivalenceClass : eqs) {
            long count;
            Number num = (Number)equivalenceClass.getProperty(Number.class.getName());
            if (num == null || (count = num.getNumber()) <= maxOccurCount) continue;
            maxOccurCount = count;
        }
        return maxOccurCount;
    }

    protected void collectTypeProp(Set<Phrase> srcPhrs, Set<Phrase> trgPhrs) {
        LOG.info((Object)" - Assigning type phrase properties...");
        this.assignTypeProp(srcPhrs, Type.EqType.SOURCE);
        this.assignTypeProp(trgPhrs, Type.EqType.TARGET);
    }

    protected void assignTypeProp(Set<? extends EquivalenceClass> eqClasses, Type.EqType type) {
        Type commonType = new Type(type);
        for (EquivalenceClass equivalenceClass : eqClasses) {
            equivalenceClass.setProperty(commonType);
        }
    }

    protected CorpusAccessor getAccessor(String kind, boolean src) throws Exception {
        CorpusAccessor accessor = null;
        if ("europarl".equals(kind)) {
            accessor = this.getEuroParlAccessor(src);
        } else if ("wiki".equals(kind)) {
            accessor = this.getWikiAccessor(src);
        } else if ("crawls".equals(kind)) {
            accessor = this.getCrawlsAccessor(src);
        } else if ("dev".equals(kind)) {
            accessor = this.getDevAccessor(src);
        } else if ("test".equals(kind)) {
            accessor = this.getTestAccessor(src);
        } else {
            LOG.error((Object)("Could not find corpus accessor for " + kind));
        }
        return accessor;
    }

    protected LexCorpusAccessor getDevAccessor(boolean src) throws Exception {
        String path = Configurator.CONFIG.getString("corpora.dev.Path");
        boolean oneSentPerLine = Configurator.CONFIG.getBoolean("corpora.dev.OneSentPerLine");
        String name = src ? Configurator.CONFIG.getString("corpora.dev.SrcName") : Configurator.CONFIG.getString("corpora.dev.TrgName");
        return new LexCorpusAccessor(name, this.appendSep(path), oneSentPerLine);
    }

    protected LexCorpusAccessor getTestAccessor(boolean src) throws Exception {
        String path = Configurator.CONFIG.getString("corpora.test.Path");
        boolean oneSentPerLine = Configurator.CONFIG.getBoolean("corpora.test.OneSentPerLine");
        String name = src ? Configurator.CONFIG.getString("corpora.test.SrcName") : Configurator.CONFIG.getString("corpora.test.TrgName");
        return new LexCorpusAccessor(name, this.appendSep(path), oneSentPerLine);
    }

    protected EuroParlCorpusAccessor getEuroParlAccessor(boolean src) throws Exception {
        String path = Configurator.CONFIG.getString("corpora.europarl.Path");
        boolean oneSentPerLine = Configurator.CONFIG.getBoolean("corpora.europarl.OneSentPerLine");
        String subDir = src ? Configurator.CONFIG.getString("corpora.europarl.SrcSubDir") : Configurator.CONFIG.getString("corpora.europarl.TrgSubDir");
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd");
        Date fromDate = sdf.parse(Configurator.CONFIG.getString("corpora.europarl.DateFrom"));
        Date toDate = sdf.parse(Configurator.CONFIG.getString("corpora.europarl.DateTo"));
        return new EuroParlCorpusAccessor(String.valueOf(this.appendSep(path)) + subDir, fromDate, toDate, oneSentPerLine);
    }

    protected CrawlCorpusAccessor getCrawlsAccessor(boolean src) throws Exception {
        String path = Configurator.CONFIG.getString("corpora.crawls.Path");
        boolean oneSentPerLine = Configurator.CONFIG.getBoolean("corpora.crawls.OneSentPerLine");
        String subDir = src ? Configurator.CONFIG.getString("corpora.crawls.SrcSubDir") : Configurator.CONFIG.getString("corpora.crawls.TrgSubDir");
        SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd");
        Date fromDate = sdf.parse(Configurator.CONFIG.getString("corpora.crawls.DateFrom"));
        Date toDate = sdf.parse(Configurator.CONFIG.getString("corpora.crawls.DateTo"));
        return new CrawlCorpusAccessor(String.valueOf(this.appendSep(path)) + subDir, fromDate, toDate, oneSentPerLine);
    }

    protected LexCorpusAccessor getWikiAccessor(boolean src) {
        String path = Configurator.CONFIG.getString("corpora.wiki.Path");
        boolean oneSentPerLine = Configurator.CONFIG.getBoolean("corpora.wiki.OneSentPerLine");
        String fileRegExp = src ? Configurator.CONFIG.getString("corpora.wiki.SrcRegExp") : Configurator.CONFIG.getString("corpora.wiki.TrgRegExp");
        return new LexCorpusAccessor(fileRegExp, this.appendSep(path), oneSentPerLine);
    }

    protected String appendSep(String str) {
        String ret;
        String string = ret = str == null ? null : str.trim();
        if (ret != null && ret.length() > 0 && !ret.endsWith(File.separator)) {
            ret = String.valueOf(ret) + File.separator;
        }
        return ret;
    }
}

