/*
 * Decompiled with CFR 0.152.
 */
package babel.util.misc;

import java.util.HashMap;
import java.util.Set;

public class InvertibleHashMap<K, V> {
    private transient HashMap<V, K> vkmap;
    private transient HashMap<K, V> kvmap;

    public InvertibleHashMap() {
        this.kvmap = new HashMap();
        this.vkmap = new HashMap();
    }

    public InvertibleHashMap(int initialCapacity) {
        this.kvmap = new HashMap(initialCapacity);
        this.vkmap = new HashMap(initialCapacity);
    }

    public InvertibleHashMap(int initialCapacity, float loadFactor) {
        this.kvmap = new HashMap(initialCapacity, loadFactor);
        this.vkmap = new HashMap(initialCapacity, loadFactor);
    }

    public int size() {
        return this.kvmap.size();
    }

    public boolean isEmpty() {
        return this.kvmap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.kvmap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.vkmap.containsKey(value);
    }

    public V getValue(Object key) {
        return this.kvmap.get(key);
    }

    public K getKey(Object val) {
        return this.vkmap.get(val);
    }

    public void put(K key, V value) {
        if (this.kvmap.containsKey(key) || this.vkmap.containsKey(value)) {
            throw new IllegalArgumentException("Non unique key or value.");
        }
        if (key == null || value == null) {
            throw new IllegalArgumentException("Key or value is null.");
        }
        this.kvmap.put(key, value);
        this.vkmap.put(value, key);
    }

    public void removeKey(Object key) {
        if (this.kvmap.containsKey(key)) {
            this.vkmap.remove(this.vkmap.get(key));
            this.kvmap.remove(key);
        }
    }

    public void removeValue(Object value) {
        if (this.vkmap.containsKey(value)) {
            this.kvmap.remove(this.vkmap.get(value));
            this.vkmap.remove(value);
        }
    }

    public void clear() {
        this.kvmap.clear();
        this.vkmap.clear();
    }

    public Set<K> keySet() {
        return this.kvmap.keySet();
    }

    public Set<V> valueSet() {
        return this.vkmap.keySet();
    }
}

