/*
 * Decompiled with CFR 0.152.
 */
package babel.prep.langid;

import babel.content.pages.Page;
import babel.prep.PrepStep;
import babel.prep.langid.LangIdMapper;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class LangIdentifier
extends PrepStep {
    static final Log LOG = LogFactory.getLog(LangIdentifier.class);
    protected static final String PAGES_SUBDIR = "pages";
    protected static final String JOB_PROP_JOB_REFERRER = "langidentifier.referrer";

    protected JobConf createJobConf(String crawlDir, String pagesSubDir, String referrer) throws IOException {
        JobConf job = new JobConf(this.getConf());
        job.setJobName("identify languages for pages in " + pagesSubDir);
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(LangIdMapper.class);
        job.setOutputFormat(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Page.class);
        FileInputFormat.addInputPath((JobConf)job, (Path)new Path(crawlDir, pagesSubDir));
        Path outDir = new Path(new Path(crawlDir, PAGES_SUBDIR), "pages.langid." + this.getCurTimeStamp());
        this.m_fs.delete(outDir, true);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
        this.setUniqueTempDir(job);
        job.set(JOB_PROP_JOB_REFERRER, referrer);
        return job;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            LangIdentifier.usage();
            return;
        }
        LangIdentifier identifier = new LangIdentifier();
        JobConf job = identifier.createJobConf(args[0], args[1], args[2]);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("LangIdentifier: " + job.getJobName()));
        }
        identifier.runPrepStep(job);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(String.valueOf(Stats.dumpStats()) + "\n"));
            LOG.info((Object)("Output: " + FileOutputFormat.getOutputPath((JobConf)job)));
            LOG.info((Object)"LangIdentifier: done");
        }
    }

    protected static void usage() {
        System.err.println("Usage: LangIdentifier crawl_dir pages_subdir referrer_url\n");
    }

    static class Stats {
        private static HashMap<String, Integer> langCounts = new HashMap();
        private static int oldLangCount = 0;
        private static int failedCount = 0;

        Stats() {
        }

        public static synchronized void incLangPageCount(String lang) {
            int curCount = langCounts.containsKey(lang) ? langCounts.get(lang) + 1 : 1;
            langCounts.put(lang, curCount);
        }

        public static synchronized void incOldLangPageCount() {
            ++oldLangCount;
        }

        public static synchronized void incFailedCount() {
            ++failedCount;
        }

        public static String dumpStats() {
            StringBuilder strBld = new StringBuilder();
            int totalCount = 0;
            for (String lang : langCounts.keySet()) {
                int count = langCounts.get(lang);
                strBld.append(String.valueOf(lang) + " : " + count + "\n");
                totalCount += count;
            }
            strBld.append(String.valueOf(totalCount) + " pages with added lang info\n");
            strBld.append(String.valueOf(oldLangCount) + " pages with existing lang info\n");
            strBld.append(String.valueOf(failedCount) + " pages failed detection");
            return strBld.toString();
        }
    }
}

