/*
 * Decompiled with CFR 0.152.
 */
package babel.content.pages;

import babel.content.pages.MetaData;
import babel.content.pages.PageVersion;
import babel.prep.extract.NutchChunk;
import babel.util.language.Language;
import babel.util.persistence.XMLPersistable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class Page
implements XMLPersistable,
Writable {
    public static final Log LOG = LogFactory.getLog(Page.class);
    private static final String XML_TAG_PAGE = "Page";
    private static final String XML_ATTRIB_URL = "URL";
    private static final String PROP_LANG = "Language";
    protected MetaData m_pageProps;
    protected String m_pageURL;
    protected ArrayList<PageVersion> m_versions;

    public Page() {
        this(null);
    }

    public Page(String url) {
        this.m_pageProps = new MetaData("PageProperties");
        this.m_pageURL = url == null ? new String() : url;
        this.m_versions = new ArrayList();
    }

    public Page(String url, Iterator<NutchChunk> values) {
        HashMap<String, List<NutchChunk>> verChunks = this.splitIntoVersions(values);
        this.m_pageProps = new MetaData("PageProperties");
        this.m_pageURL = url == null ? new String() : url;
        this.m_versions = new ArrayList(verChunks.size());
        for (String segId : verChunks.keySet()) {
            PageVersion curVer = new PageVersion(segId, verChunks.get(segId), this);
            if (!curVer.isNutchComplete()) continue;
            this.addVersion(curVer);
        }
        this.m_versions.trimToSize();
    }

    public void merge(Page other) {
        if (other == null || !this.m_pageURL.equals(other.m_pageURL)) {
            throw new IllegalArgumentException("null ref or different URL");
        }
        this.addProperties(other.m_pageProps);
        for (PageVersion ver : other.m_versions) {
            this.addVersion(ver);
        }
    }

    public String pageURL() {
        return this.m_pageURL;
    }

    public MetaData pageProperties() {
        return this.m_pageProps;
    }

    public Language getLanguage() {
        return Language.fromString(this.m_pageProps.getFirst(PROP_LANG));
    }

    public void setLanguage(Language lang) {
        String oldLang = this.m_pageProps.getFirst(PROP_LANG);
        String newLang = lang != null ? lang.toString() : null;
        this.m_pageProps.remove(PROP_LANG);
        if (newLang != null) {
            this.m_pageProps.set(PROP_LANG, newLang);
        }
        if (LOG.isWarnEnabled() && oldLang != null && !oldLang.equals(newLang)) {
            LOG.warn((Object)("Changing language of " + this.m_pageURL + " from " + oldLang + " to " + (newLang == null ? " nothing." : String.valueOf(newLang) + ".")));
        }
    }

    public void addProperties(MetaData props) {
        if (props != null) {
            String[] keys = props.keys();
            int i = 0;
            while (i < keys.length) {
                if (!this.m_pageProps.hasKey(keys[i])) {
                    this.m_pageProps.add(keys[i], props.get(keys[i]));
                }
                ++i;
            }
        }
    }

    public int numVersions() {
        return this.m_versions == null ? 0 : this.m_versions.size();
    }

    public List<PageVersion> pageVersions() {
        return this.m_versions;
    }

    public boolean addVersion(PageVersion ver) {
        boolean added = false;
        int idx = this.m_versions.indexOf(ver);
        if (idx >= 0) {
            Long fetchCur = this.m_versions.get(idx).getFetchTime();
            Long fetchOther = ver.getFetchTime();
            if (fetchCur != null && fetchOther != null && fetchCur > fetchOther) {
                this.m_versions.remove(idx);
                added = this.m_versions.add(ver);
            }
        } else {
            added = this.m_versions.add(ver);
        }
        return added;
    }

    public String toString() {
        StringBuilder strBld = new StringBuilder();
        strBld.append("Page URL: " + this.m_pageURL + "\n\n");
        for (PageVersion ver : this.m_versions) {
            strBld.append(String.valueOf(ver.toString()) + "\n");
        }
        return strBld.toString();
    }

    @Override
    public void persist(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_TAG_PAGE);
        writer.writeAttribute(XML_ATTRIB_URL, this.m_pageURL);
        if (this.m_pageProps.numKeys() > 0) {
            this.m_pageProps.persist(writer);
        }
        for (PageVersion ver : this.m_versions) {
            ver.persist(writer);
        }
        writer.writeEndElement();
    }

    @Override
    public void unpersist(XMLStreamReader reader) throws XMLStreamException {
        int event;
        this.m_pageURL = reader.getAttributeValue(0);
        this.m_versions.clear();
        while ((event = reader.next()) != 2 || !XML_TAG_PAGE.equals(reader.getName().toString())) {
            if (event != 1) continue;
            String elemTag = reader.getName().toString();
            if ("MetaData".equals(elemTag)) {
                this.m_pageProps.unpersist(reader);
                continue;
            }
            if (!"PageVersion".equals(elemTag)) continue;
            PageVersion ver = new PageVersion();
            ver.unpersist(reader);
            this.m_versions.add(ver);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.m_pageURL = Text.readString((DataInput)in);
        this.m_pageProps.readFields(in);
        int numVersions = WritableUtils.readVInt((DataInput)in);
        this.m_versions = new ArrayList(numVersions);
        int i = 0;
        while (i < numVersions) {
            PageVersion curVer = new PageVersion();
            curVer.readFields(in);
            this.m_versions.add(curVer);
            ++i;
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.m_pageURL);
        this.m_pageProps.write(out);
        WritableUtils.writeVInt((DataOutput)out, (int)this.m_versions.size());
        for (PageVersion ver : this.m_versions) {
            ver.write(out);
        }
    }

    protected HashMap<String, List<NutchChunk>> splitIntoVersions(Iterator<NutchChunk> values) {
        HashMap<String, List<NutchChunk>> verChunks = new HashMap<String, List<NutchChunk>>();
        if (values != null) {
            while (values.hasNext()) {
                NutchChunk curChunk = new NutchChunk(values.next());
                String curSegId = curChunk.getSegmentId();
                List<NutchChunk> curList = verChunks.get(curSegId);
                if (curList == null) {
                    curList = new LinkedList<NutchChunk>();
                    verChunks.put(curSegId, curList);
                }
                curList.add(curChunk);
            }
        }
        return verChunks;
    }
}

