/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.lshcontext;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.LSHPropertyCollector;
import babel.content.eqclasses.properties.context.Context;
import babel.content.eqclasses.properties.lshcontext.LSHContext;
import babel.util.jerboa.LSH;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LSHContextCollector
extends LSHPropertyCollector {
    private static final Log LOG = LogFactory.getLog(LSHContextCollector.class);
    private static final LSH CONTEXT_LSH = new LSH();

    public LSHContextCollector(boolean removeOrigProp) {
        super(removeOrigProp);
    }

    @Override
    public void collectProperty(Set<? extends EquivalenceClass> eqClasses) throws Exception {
        HashMap<String, Double> features = new HashMap<String, Double>();
        int numUnscored = 0;
        for (EquivalenceClass equivalenceClass : eqClasses) {
            Context context = (Context)equivalenceClass.getProperty(Context.class.getName());
            if (context == null || !context.areContItemsScored()) {
                ++numUnscored;
                continue;
            }
            features.clear();
            for (Context.ContextualItem contItem : context.getContextualItems()) {
                features.put(contItem.getContextEqId().toString(), contItem.getScore());
            }
            equivalenceClass.setProperty(new LSHContext(equivalenceClass, CONTEXT_LSH.buildSignature(features)));
            if (!this.m_removeOrigProp) continue;
            equivalenceClass.removeProperty(Context.class.getName());
        }
        if (numUnscored > 0) {
            LOG.error((Object)("Could not compute LSH signature for " + numUnscored + " equvalence classes (either missing or unscored context)."));
        }
    }
}

