/*
 * Decompiled with CFR 0.152.
 */
package babel.content.corpora.accessors;

import babel.content.corpora.accessors.CorpusAccessor;
import babel.util.misc.FileList;
import babel.util.misc.RegExFileNameFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;

public class LexCorpusAccessor
extends CorpusAccessor {
    protected static final String DEFAULT_CHARSET = "UTF-8";
    protected int m_curFileNum;
    protected String m_encoding;
    protected FileList m_files;

    public LexCorpusAccessor(String fileNameRegEx, String corpusDir, boolean oneSentPerLine) {
        this(fileNameRegEx, corpusDir, DEFAULT_CHARSET, oneSentPerLine);
    }

    public LexCorpusAccessor(String fileNameRegEx, String corpusDir, String charset, boolean oneSentPerLine) {
        super(oneSentPerLine);
        this.resetFiles();
        this.m_files = new FileList(corpusDir, new RegExFileNameFilter(fileNameRegEx));
        this.m_encoding = charset;
    }

    @Override
    public InputStreamReader getCorpusReader() {
        InputStreamReader retReader = null;
        this.m_files.gather();
        this.m_files.sort();
        try {
            retReader = new InputStreamReader((InputStream)new SequenceInputStream(this.m_files), this.m_encoding);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
        return retReader;
    }

    @Override
    public CorpusAccessor.NamedInputStreamReader getCurFileReader() {
        CorpusAccessor.NamedInputStreamReader namedReader = null;
        try {
            if (this.m_curFileNum != -1) {
                String fileName = this.m_files.getFileName(this.m_curFileNum);
                int lastSlashIdx = fileName.lastIndexOf(47);
                String fileHandle = lastSlashIdx >= 0 ? fileName.substring(lastSlashIdx + 1) : fileName;
                namedReader = new CorpusAccessor.NamedInputStreamReader(fileHandle, new InputStreamReader((InputStream)new FileInputStream(fileName), this.m_encoding));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
        return namedReader;
    }

    @Override
    public boolean nextFile() {
        boolean hasNext = false;
        if (this.m_curFileNum == -1) {
            this.m_files.gather();
            this.m_files.sort();
            hasNext = this.m_files.size() > 0;
            if (hasNext) {
                this.m_curFileNum = 0;
            }
        } else {
            hasNext = this.m_curFileNum + 1 < this.m_files.size();
            if (hasNext) {
                ++this.m_curFileNum;
            }
        }
        return hasNext;
    }

    @Override
    public boolean resetFiles() {
        this.m_curFileNum = -1;
        return true;
    }
}

