/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.List;
import simplenlg.features.Category;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.realiser.CoordinatePhrase;
import simplenlg.realiser.CoordinatePhraseSet;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.StringPhraseSpec;

public class CoordinateStringPhraseSpec
extends StringPhraseSpec
implements CoordinatePhrase<StringPhraseSpec> {
    private CoordinatePhraseSet<StringPhraseSpec> coordinator = new CoordinatePhraseSet<CoordinateStringPhraseSpec>(this);

    public CoordinateStringPhraseSpec(StringPhraseSpec ... coords) {
        if (coords.length > 0) {
            this.coordinator.addCoordinates(coords);
            this.setCategory(coords[0].getCategory());
        }
    }

    @Override
    public void setConjunction(Conjunction coord) {
        this.coordinator.setConjunction(coord);
    }

    @Override
    public void setCategory(Category c) {
        this.category = c;
        for (StringPhraseSpec string : this.coordinator.coordinates) {
            string.setCategory(c);
        }
    }

    @Override
    public void setConjunction(String coord) {
        this.coordinator.setConjunction(coord);
    }

    @Override
    public Conjunction getConjunction() {
        return this.coordinator.getConjunction();
    }

    @Override
    public String getConjunctionAsString() {
        return this.coordinator.getConjunctionAsString();
    }

    public void addCoordinates(StringPhraseSpec ... coords) {
        this.coordinator.addCoordinates(coords);
    }

    public void setCoordinates(StringPhraseSpec ... coords) {
        this.coordinator.clearCoordinates();
        this.addCoordinates(coords);
    }

    @Override
    public List<StringPhraseSpec> getCoordinates() {
        return this.coordinator.getCoordinates();
    }

    @Override
    String realise(Realiser r) {
        return this.coordinator.realise(r);
    }
}

