/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.optimizer.BodyCodegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptTransformer;
import org.mozilla.javascript.optimizer.Optimizer;

public class Codegen
extends Interpreter {
    static final String DEFAULT_MAIN_METHOD_CLASS = "org.mozilla.javascript.optimizer.OptRuntime";
    private static final String SUPER_CLASS_NAME = "org.mozilla.javascript.NativeFunction";
    static final String DIRECT_CALL_PARENT_FIELD = "_dcp";
    private static final String ID_FIELD_NAME = "_id";
    private static final String REGEXP_INIT_METHOD_NAME = "_reInit";
    private static final String REGEXP_INIT_METHOD_SIGNATURE = "(Lorg/mozilla/javascript/RegExpProxy;Lorg/mozilla/javascript/Context;)V";
    static final String REGEXP_ARRAY_FIELD_NAME = "_re";
    static final String REGEXP_ARRAY_FIELD_TYPE = "[Ljava/lang/Object;";
    static final String FUNCTION_INIT_SIGNATURE = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)V";
    static final String FUNCTION_CONSTRUCTOR_SIGNATURE = "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V";
    private static final Object globalLock = new Object();
    private static int globalSerialClassCounter;
    private CompilerEnvirons compilerEnv;
    private ObjArray directCallTargets;
    ScriptOrFnNode[] scriptOrFnNodes;
    private ObjToIntMap scriptOrFnIndexes;
    private String mainMethodClass = "org.mozilla.javascript.optimizer.OptRuntime";
    String mainClassName;
    String mainClassSignature;
    private double[] itsConstantList;
    private int itsConstantListSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object compile(CompilerEnvirons compilerEnvirons, ScriptOrFnNode scriptOrFnNode, String string, boolean bl) {
        int n;
        Object object = globalLock;
        synchronized (object) {
            n = ++globalSerialClassCounter;
        }
        object = "org.mozilla.javascript.gen.c" + n;
        byte[] byArray = this.compileToClassFile(compilerEnvirons, (String)object, scriptOrFnNode, string, bl);
        return new Object[]{object, byArray};
    }

    public Script createScriptObject(Object object, Object object2) {
        Script script;
        Class clazz = this.defineClass(object, object2);
        try {
            script = (Script)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate compiled class:" + exception.toString());
        }
        return script;
    }

    public Function createFunctionObject(Context context, Scriptable scriptable, Object object, Object object2) {
        NativeFunction nativeFunction;
        Class clazz = this.defineClass(object, object2);
        try {
            Constructor<?> constructor = clazz.getConstructors()[0];
            Object[] objectArray = new Object[]{scriptable, context, new Integer(0)};
            nativeFunction = (NativeFunction)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate compiled class:" + exception.toString());
        }
        return nativeFunction;
    }

    private Class defineClass(Object object, Object object2) {
        RuntimeException runtimeException;
        Object[] objectArray = (Object[])object;
        String string = (String)objectArray[0];
        byte[] byArray = (byte[])objectArray[1];
        ClassLoader classLoader = this.getClass().getClassLoader();
        GeneratedClassLoader generatedClassLoader = SecurityController.createLoader(classLoader, object2);
        try {
            Class clazz = generatedClassLoader.defineClass(string, byArray);
            generatedClassLoader.linkClass(clazz);
            return clazz;
        }
        catch (SecurityException securityException) {
            runtimeException = securityException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            runtimeException = illegalArgumentException;
        }
        throw new RuntimeException("Malformed optimizer package " + runtimeException);
    }

    byte[] compileToClassFile(CompilerEnvirons compilerEnvirons, String string, ScriptOrFnNode scriptOrFnNode, String string2, boolean bl) {
        this.compilerEnv = compilerEnvirons;
        this.transform(scriptOrFnNode);
        if (bl) {
            scriptOrFnNode = scriptOrFnNode.getFunctionNode(0);
        }
        this.initScriptOrFnNodesData(scriptOrFnNode);
        this.mainClassName = string;
        this.mainClassSignature = ClassFileWriter.classNameToSignature(string);
        return this.generateCode(string2);
    }

    private void transform(ScriptOrFnNode scriptOrFnNode) {
        Codegen.initOptFunctions_r(scriptOrFnNode);
        int n = this.compilerEnv.getOptimizationLevel();
        Hashtable<String, OptFunctionNode> hashtable = null;
        if (n > 0 && scriptOrFnNode.getType() == 132) {
            int n2 = scriptOrFnNode.getFunctionCount();
            for (int i = 0; i != n2; ++i) {
                String string;
                OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptOrFnNode, i);
                if (optFunctionNode.fnode.getFunctionType() != 1 || (string = optFunctionNode.fnode.getFunctionName()).length() == 0) continue;
                if (hashtable == null) {
                    hashtable = new Hashtable<String, OptFunctionNode>();
                }
                hashtable.put(string, optFunctionNode);
            }
        }
        if (hashtable != null) {
            this.directCallTargets = new ObjArray();
        }
        OptTransformer optTransformer = new OptTransformer(hashtable, this.directCallTargets);
        optTransformer.transform(scriptOrFnNode);
        if (n > 0) {
            new Optimizer().optimize(scriptOrFnNode);
        }
    }

    private static void initOptFunctions_r(ScriptOrFnNode scriptOrFnNode) {
        int n = scriptOrFnNode.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = scriptOrFnNode.getFunctionNode(i);
            new OptFunctionNode(functionNode);
            Codegen.initOptFunctions_r(functionNode);
        }
    }

    private void initScriptOrFnNodesData(ScriptOrFnNode scriptOrFnNode) {
        ObjArray objArray = new ObjArray();
        Codegen.collectScriptOrFnNodes_r(scriptOrFnNode, objArray);
        int n = objArray.size();
        this.scriptOrFnNodes = new ScriptOrFnNode[n];
        objArray.toArray(this.scriptOrFnNodes);
        this.scriptOrFnIndexes = new ObjToIntMap(n);
        for (int i = 0; i != n; ++i) {
            this.scriptOrFnIndexes.put(this.scriptOrFnNodes[i], i);
        }
    }

    private static void collectScriptOrFnNodes_r(ScriptOrFnNode scriptOrFnNode, ObjArray objArray) {
        objArray.add(scriptOrFnNode);
        int n = scriptOrFnNode.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            Codegen.collectScriptOrFnNodes_r(scriptOrFnNode.getFunctionNode(i), objArray);
        }
    }

    private byte[] generateCode(String string) {
        int n;
        boolean bl = this.scriptOrFnNodes[0].getType() == 132;
        boolean bl2 = this.scriptOrFnNodes.length > 1 || !bl;
        String string2 = null;
        if (this.compilerEnv.isGenerateDebugInfo()) {
            string2 = this.scriptOrFnNodes[0].getSourceName();
        }
        ClassFileWriter classFileWriter = new ClassFileWriter(this.mainClassName, SUPER_CLASS_NAME, string2);
        classFileWriter.addField(ID_FIELD_NAME, "I", (short)2);
        classFileWriter.addField(DIRECT_CALL_PARENT_FIELD, this.mainClassSignature, (short)2);
        classFileWriter.addField(REGEXP_ARRAY_FIELD_NAME, REGEXP_ARRAY_FIELD_TYPE, (short)2);
        if (bl2) {
            this.generateFunctionConstructor(classFileWriter);
        }
        if (bl) {
            classFileWriter.addInterface("org/mozilla/javascript/Script");
            this.generateScriptCtor(classFileWriter);
            this.generateMain(classFileWriter);
            this.generateExecute(classFileWriter);
        }
        this.generateCallMethod(classFileWriter);
        this.generateNativeFunctionOverrides(classFileWriter, string);
        int n2 = this.scriptOrFnNodes.length;
        for (n = 0; n != n2; ++n) {
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[n];
            BodyCodegen bodyCodegen = new BodyCodegen();
            bodyCodegen.cfw = classFileWriter;
            bodyCodegen.codegen = this;
            bodyCodegen.compilerEnv = this.compilerEnv;
            bodyCodegen.scriptOrFn = scriptOrFnNode;
            bodyCodegen.generateBodyCode();
            if (scriptOrFnNode.getType() != 105) continue;
            OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptOrFnNode);
            this.generateFunctionInit(classFileWriter, optFunctionNode);
            if (!optFunctionNode.isTargetOfDirectCall()) continue;
            this.emitDirectConstructor(classFileWriter, optFunctionNode);
        }
        if (this.directCallTargets != null) {
            n = this.directCallTargets.size();
            for (int i = 0; i != n; ++i) {
                classFileWriter.addField(Codegen.getDirectTargetFieldName(i), this.mainClassSignature, (short)2);
            }
        }
        this.emitRegExpInit(classFileWriter);
        this.emitConstantDudeInitializers(classFileWriter);
        return classFileWriter.toByteArray();
    }

    private void emitDirectConstructor(ClassFileWriter classFileWriter, OptFunctionNode optFunctionNode) {
        int n;
        classFileWriter.startMethod(this.getDirectCtorName(optFunctionNode.fnode), this.getBodyMethodSignature(optFunctionNode.fnode), (short)10);
        int n2 = optFunctionNode.fnode.getParamCount();
        int n3 = 4 + n2 * 3 + 1;
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addInvoke(182, "org/mozilla/javascript/BaseFunction", "createObject", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.addAStore(n3);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(n3);
        for (n = 0; n < n2; ++n) {
            classFileWriter.addALoad(4 + n * 3);
            classFileWriter.addDLoad(5 + n * 3);
        }
        classFileWriter.addALoad(4 + n2 * 3);
        classFileWriter.addInvoke(184, this.mainClassName, this.getBodyMethodName(optFunctionNode.fnode), this.getBodyMethodSignature(optFunctionNode.fnode));
        n = classFileWriter.acquireLabel();
        classFileWriter.add(89);
        classFileWriter.add(193, "org/mozilla/javascript/Scriptable");
        classFileWriter.add(153, n);
        classFileWriter.add(192, "org/mozilla/javascript/Scriptable");
        classFileWriter.add(176);
        classFileWriter.markLabel(n);
        classFileWriter.addALoad(n3);
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)(n3 + 1));
    }

    private void generateCallMethod(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        int n = classFileWriter.acquireLabel();
        classFileWriter.addALoad(1);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "hasTopCall", "(Lorg/mozilla/javascript/Context;)Z");
        classFileWriter.add(154, n);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(3);
        classFileWriter.addALoad(4);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "doTopCall", "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        classFileWriter.add(176);
        classFileWriter.markLabel(n);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(3);
        classFileWriter.addALoad(4);
        int n2 = this.scriptOrFnNodes.length;
        boolean bl = 2 <= n2;
        int n3 = 0;
        short s = 0;
        if (bl) {
            classFileWriter.addLoadThis();
            classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
            n3 = classFileWriter.addTableSwitch(1, n2 - 1);
        }
        for (int i = 0; i != n2; ++i) {
            int n4;
            OptFunctionNode optFunctionNode;
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[i];
            if (bl) {
                if (i == 0) {
                    classFileWriter.markTableSwitchDefault(n3);
                    s = classFileWriter.getStackTop();
                } else {
                    classFileWriter.markTableSwitchCase(n3, i - 1, s);
                }
            }
            if (scriptOrFnNode.getType() == 105 && (optFunctionNode = OptFunctionNode.get(scriptOrFnNode)).isTargetOfDirectCall() && (n4 = optFunctionNode.fnode.getParamCount()) != 0) {
                for (int j = 0; j != n4; ++j) {
                    classFileWriter.add(190);
                    classFileWriter.addPush(j);
                    int n5 = classFileWriter.acquireLabel();
                    int n6 = classFileWriter.acquireLabel();
                    classFileWriter.add(164, n5);
                    classFileWriter.addALoad(4);
                    classFileWriter.addPush(j);
                    classFileWriter.add(50);
                    classFileWriter.add(167, n6);
                    classFileWriter.markLabel(n5);
                    Codegen.pushUndefined(classFileWriter);
                    classFileWriter.markLabel(n6);
                    classFileWriter.adjustStackTop(-1);
                    classFileWriter.addPush(0.0);
                    classFileWriter.addALoad(4);
                }
            }
            classFileWriter.addInvoke(184, this.mainClassName, this.getBodyMethodName(scriptOrFnNode), this.getBodyMethodSignature(scriptOrFnNode));
            classFileWriter.add(176);
        }
        classFileWriter.stopMethod((short)5);
    }

    private void generateMain(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("main", "([Ljava/lang/String;)V", (short)9);
        classFileWriter.add(187, classFileWriter.getClassName());
        classFileWriter.add(89);
        classFileWriter.addInvoke(183, classFileWriter.getClassName(), "<init>", "()V");
        classFileWriter.add(42);
        classFileWriter.addInvoke(184, this.mainMethodClass, "main", "(Lorg/mozilla/javascript/Script;[Ljava/lang/String;)V");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)1);
    }

    private void generateExecute(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("exec", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;", (short)17);
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.add(89);
        classFileWriter.add(1);
        classFileWriter.addInvoke(182, classFileWriter.getClassName(), "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)3);
    }

    private void generateScriptCtor(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.addLoadThis();
        classFileWriter.addInvoke(183, SUPER_CLASS_NAME, "<init>", "()V");
        classFileWriter.addLoadThis();
        classFileWriter.addPush(0);
        classFileWriter.add(181, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)1);
    }

    private void generateFunctionConstructor(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("<init>", FUNCTION_CONSTRUCTOR_SIGNATURE, (short)1);
        classFileWriter.addALoad(0);
        classFileWriter.addInvoke(183, SUPER_CLASS_NAME, "<init>", "()V");
        classFileWriter.addLoadThis();
        classFileWriter.addILoad(3);
        classFileWriter.add(181, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(1);
        int n = this.scriptOrFnNodes[0].getType() == 132 ? 1 : 0;
        int n2 = this.scriptOrFnNodes.length;
        if (n == n2) {
            throw Codegen.badTree();
        }
        boolean bl = 2 <= n2 - n;
        int n3 = 0;
        short s = 0;
        if (bl) {
            classFileWriter.addILoad(3);
            n3 = classFileWriter.addTableSwitch(n + 1, n2 - 1);
        }
        for (int i = n; i != n2; ++i) {
            if (bl) {
                if (i == n) {
                    classFileWriter.markTableSwitchDefault(n3);
                    s = classFileWriter.getStackTop();
                } else {
                    classFileWriter.markTableSwitchCase(n3, i - 1 - n, s);
                }
            }
            OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFnNodes[i]);
            classFileWriter.addInvoke(182, this.mainClassName, this.getFunctionInitMethodName(optFunctionNode), FUNCTION_INIT_SIGNATURE);
            classFileWriter.add(177);
        }
        classFileWriter.stopMethod((short)4);
    }

    private void generateFunctionInit(ClassFileWriter classFileWriter, OptFunctionNode optFunctionNode) {
        classFileWriter.startMethod(this.getFunctionInitMethodName(optFunctionNode), FUNCTION_INIT_SIGNATURE, (short)18);
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addInvoke(182, "org/mozilla/javascript/NativeFunction", "initScriptFunction", FUNCTION_INIT_SIGNATURE);
        int n = optFunctionNode.fnode.getRegexpCount();
        if (n != 0) {
            classFileWriter.addLoadThis();
            this.pushRegExpArray(classFileWriter, optFunctionNode.fnode, 1, 2);
            classFileWriter.add(181, this.mainClassName, REGEXP_ARRAY_FIELD_NAME, REGEXP_ARRAY_FIELD_TYPE);
        }
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)3);
    }

    private void generateNativeFunctionOverrides(ClassFileWriter classFileWriter, String string) {
        classFileWriter.startMethod("getLanguageVersion", "()I", (short)1);
        classFileWriter.addPush(this.compilerEnv.getLanguageVersion());
        classFileWriter.add(172);
        classFileWriter.stopMethod((short)1);
        for (int i = 0; i != 5; ++i) {
            short s;
            if (i == 4 && string == null) continue;
            switch (i) {
                case 0: {
                    s = 1;
                    classFileWriter.startMethod("getFunctionName", "()Ljava/lang/String;", (short)1);
                    break;
                }
                case 1: {
                    s = 1;
                    classFileWriter.startMethod("getParamCount", "()I", (short)1);
                    break;
                }
                case 2: {
                    s = 1;
                    classFileWriter.startMethod("getParamAndVarCount", "()I", (short)1);
                    break;
                }
                case 3: {
                    s = 2;
                    classFileWriter.startMethod("getParamOrVarName", "(I)Ljava/lang/String;", (short)1);
                    break;
                }
                case 4: {
                    s = 1;
                    classFileWriter.startMethod("getEncodedSource", "()Ljava/lang/String;", (short)1);
                    classFileWriter.addPush(string);
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            int n = this.scriptOrFnNodes.length;
            int n2 = 0;
            int n3 = 0;
            if (n > 1) {
                classFileWriter.addLoadThis();
                classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
                n2 = classFileWriter.addTableSwitch(1, n - 1);
            }
            block15: for (int j = 0; j != n; ++j) {
                ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[j];
                if (j == 0) {
                    if (n > 1) {
                        classFileWriter.markTableSwitchDefault(n2);
                        n3 = classFileWriter.getStackTop();
                    }
                } else {
                    classFileWriter.markTableSwitchCase(n2, j - 1, n3);
                }
                switch (i) {
                    case 0: {
                        if (scriptOrFnNode.getType() == 132) {
                            classFileWriter.addPush("");
                        } else {
                            String string2 = ((FunctionNode)scriptOrFnNode).getFunctionName();
                            classFileWriter.addPush(string2);
                        }
                        classFileWriter.add(176);
                        continue block15;
                    }
                    case 1: {
                        classFileWriter.addPush(scriptOrFnNode.getParamCount());
                        classFileWriter.add(172);
                        continue block15;
                    }
                    case 2: {
                        classFileWriter.addPush(scriptOrFnNode.getParamAndVarCount());
                        classFileWriter.add(172);
                        continue block15;
                    }
                    case 3: {
                        int n4 = scriptOrFnNode.getParamAndVarCount();
                        if (n4 == 0) {
                            classFileWriter.add(1);
                            classFileWriter.add(176);
                            continue block15;
                        }
                        if (n4 == 1) {
                            classFileWriter.addPush(scriptOrFnNode.getParamOrVarName(0));
                            classFileWriter.add(176);
                            continue block15;
                        }
                        classFileWriter.addILoad(1);
                        int n5 = classFileWriter.addTableSwitch(1, n4 - 1);
                        for (int k = 0; k != n4; ++k) {
                            if (classFileWriter.getStackTop() != 0) {
                                Kit.codeBug();
                            }
                            String string3 = scriptOrFnNode.getParamOrVarName(k);
                            if (k == 0) {
                                classFileWriter.markTableSwitchDefault(n5);
                            } else {
                                classFileWriter.markTableSwitchCase(n5, k - 1, 0);
                            }
                            classFileWriter.addPush(string3);
                            classFileWriter.add(176);
                        }
                        continue block15;
                    }
                    case 4: {
                        classFileWriter.addPush(scriptOrFnNode.getEncodedSourceStart());
                        classFileWriter.addPush(scriptOrFnNode.getEncodedSourceEnd());
                        classFileWriter.addInvoke(182, "java/lang/String", "substring", "(II)Ljava/lang/String;");
                        classFileWriter.add(176);
                        continue block15;
                    }
                    default: {
                        throw Kit.codeBug();
                    }
                }
            }
            classFileWriter.stopMethod(s);
        }
    }

    private void emitRegExpInit(ClassFileWriter classFileWriter) {
        int n;
        int n2 = 0;
        for (n = 0; n != this.scriptOrFnNodes.length; ++n) {
            n2 += this.scriptOrFnNodes[n].getRegexpCount();
        }
        if (n2 == 0) {
            return;
        }
        classFileWriter.startMethod(REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE, (short)42);
        classFileWriter.addField("_reInitDone", "Z", (short)10);
        classFileWriter.add(178, this.mainClassName, "_reInitDone", "Z");
        n = classFileWriter.acquireLabel();
        classFileWriter.add(153, n);
        classFileWriter.add(177);
        classFileWriter.markLabel(n);
        for (int i = 0; i != this.scriptOrFnNodes.length; ++i) {
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[i];
            int n3 = scriptOrFnNode.getRegexpCount();
            for (int j = 0; j != n3; ++j) {
                String string = this.getCompiledRegexpName(scriptOrFnNode, j);
                String string2 = "Ljava/lang/Object;";
                String string3 = scriptOrFnNode.getRegexpString(j);
                String string4 = scriptOrFnNode.getRegexpFlags(j);
                classFileWriter.addField(string, string2, (short)10);
                classFileWriter.addALoad(0);
                classFileWriter.addALoad(1);
                classFileWriter.addPush(string3);
                if (string4 == null) {
                    classFileWriter.add(1);
                } else {
                    classFileWriter.addPush(string4);
                }
                classFileWriter.addInvoke(185, "org/mozilla/javascript/RegExpProxy", "compileRegExp", "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
                classFileWriter.add(179, this.mainClassName, string, string2);
            }
        }
        classFileWriter.addPush(1);
        classFileWriter.add(179, this.mainClassName, "_reInitDone", "Z");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)2);
    }

    private void emitConstantDudeInitializers(ClassFileWriter classFileWriter) {
        int n = this.itsConstantListSize;
        if (n == 0) {
            return;
        }
        classFileWriter.startMethod("<clinit>", "()V", (short)24);
        double[] dArray = this.itsConstantList;
        for (int i = 0; i != n; ++i) {
            double d = dArray[i];
            String string = "_k" + i;
            String string2 = Codegen.getStaticConstantWrapperType(d);
            classFileWriter.addField(string, string2, (short)10);
            int n2 = (int)d;
            if ((double)n2 == d) {
                classFileWriter.add(187, "java/lang/Integer");
                classFileWriter.add(89);
                classFileWriter.addPush(n2);
                classFileWriter.addInvoke(183, "java/lang/Integer", "<init>", "(I)V");
            } else {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            }
            classFileWriter.add(179, this.mainClassName, string, string2);
        }
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)0);
    }

    void pushRegExpArray(ClassFileWriter classFileWriter, ScriptOrFnNode scriptOrFnNode, int n, int n2) {
        int n3 = scriptOrFnNode.getRegexpCount();
        if (n3 == 0) {
            throw Codegen.badTree();
        }
        classFileWriter.addPush(n3);
        classFileWriter.add(189, "java/lang/Object");
        classFileWriter.addALoad(n);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "checkRegExpProxy", "(Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/RegExpProxy;");
        classFileWriter.add(89);
        classFileWriter.addALoad(n);
        classFileWriter.addInvoke(184, this.mainClassName, REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE);
        for (int i = 0; i != n3; ++i) {
            classFileWriter.add(92);
            classFileWriter.addALoad(n);
            classFileWriter.addALoad(n2);
            classFileWriter.add(178, this.mainClassName, this.getCompiledRegexpName(scriptOrFnNode, i), "Ljava/lang/Object;");
            classFileWriter.addInvoke(185, "org/mozilla/javascript/RegExpProxy", "wrapRegExp", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            classFileWriter.addPush(i);
            classFileWriter.add(95);
            classFileWriter.add(83);
        }
        classFileWriter.add(87);
    }

    void pushNumberAsObject(ClassFileWriter classFileWriter, double d) {
        if (d == 0.0) {
            if (1.0 / d > 0.0) {
                classFileWriter.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "zeroObj", "Ljava/lang/Double;");
            } else {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            }
        } else {
            if (d == 1.0) {
                classFileWriter.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "oneObj", "Ljava/lang/Double;");
                return;
            }
            if (d == -1.0) {
                classFileWriter.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "minusOneObj", "Ljava/lang/Double;");
            } else if (d != d) {
                classFileWriter.add(178, "org/mozilla/javascript/ScriptRuntime", "NaNobj", "Ljava/lang/Double;");
            } else if (this.itsConstantListSize >= 2000) {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            } else {
                int n;
                Object object;
                int n2 = this.itsConstantListSize;
                if (n2 == 0) {
                    this.itsConstantList = new double[64];
                } else {
                    object = this.itsConstantList;
                    for (n = 0; n != n2 && object[n] != d; ++n) {
                    }
                    if (n2 == ((double[])object).length) {
                        object = new double[n2 * 2];
                        System.arraycopy(this.itsConstantList, 0, object, 0, n2);
                        this.itsConstantList = object;
                    }
                }
                if (n == n2) {
                    this.itsConstantList[n2] = d;
                    this.itsConstantListSize = n2 + 1;
                }
                object = "_k" + n;
                String string = Codegen.getStaticConstantWrapperType(d);
                classFileWriter.add(178, this.mainClassName, (String)object, string);
            }
        }
    }

    private static void addDoubleWrap(ClassFileWriter classFileWriter) {
        classFileWriter.addInvoke(184, "org/mozilla/javascript/optimizer/OptRuntime", "wrapDouble", "(D)Ljava/lang/Double;");
    }

    private static String getStaticConstantWrapperType(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return "Ljava/lang/Integer;";
        }
        return "Ljava/lang/Double;";
    }

    static void pushUndefined(ClassFileWriter classFileWriter) {
        classFileWriter.add(178, "org/mozilla/javascript/Undefined", "instance", "Ljava/lang/Object;");
    }

    int getIndex(ScriptOrFnNode scriptOrFnNode) {
        return this.scriptOrFnIndexes.getExisting(scriptOrFnNode);
    }

    static String getDirectTargetFieldName(int n) {
        return "_dt" + n;
    }

    String getDirectCtorName(ScriptOrFnNode scriptOrFnNode) {
        return "_n" + this.getIndex(scriptOrFnNode);
    }

    String getBodyMethodName(ScriptOrFnNode scriptOrFnNode) {
        return "_c" + this.getIndex(scriptOrFnNode);
    }

    String getBodyMethodSignature(ScriptOrFnNode scriptOrFnNode) {
        OptFunctionNode optFunctionNode;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.mainClassSignature);
        stringBuffer.append("Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;");
        if (scriptOrFnNode.getType() == 105 && (optFunctionNode = OptFunctionNode.get(scriptOrFnNode)).isTargetOfDirectCall()) {
            int n = optFunctionNode.fnode.getParamCount();
            for (int i = 0; i != n; ++i) {
                stringBuffer.append("Ljava/lang/Object;D");
            }
        }
        stringBuffer.append("[Ljava/lang/Object;)Ljava/lang/Object;");
        return stringBuffer.toString();
    }

    String getFunctionInitMethodName(OptFunctionNode optFunctionNode) {
        return "_i" + this.getIndex(optFunctionNode.fnode);
    }

    String getCompiledRegexpName(ScriptOrFnNode scriptOrFnNode, int n) {
        return REGEXP_ARRAY_FIELD_NAME + this.getIndex(scriptOrFnNode) + "_" + n;
    }

    static RuntimeException badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }

    void setMainMethodClass(String string) {
        this.mainMethodClass = string;
    }
}

