/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.morph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import simplenlg.lexicon.lexicalitems.ContentWord;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.lexicalitems.Word;
import simplenlg.lexicon.morph.InflectionRule;
import simplenlg.lexicon.morph.MorphologicalRule;
import simplenlg.lexicon.morph.PatternActionRule;
import simplenlg.lexicon.morph.WordLists;

public class InflectionRule<T extends ContentWord>
implements MorphologicalRule<T> {
    List<PatternActionRule> patternActionRules;
    PatternActionRule defaultRule;
    String name;
    Matcher wordMatcher = Pattern.compile("^(([a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df_0-9]+)(-[a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df_0-9]+)*)(\\s(([a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df_0-9]+)(-[a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df_0-9]+)*))*$").matcher("blablabla");
    boolean umlaut = false;

    public InflectionRule() {
        this.patternActionRules = new ArrayList<PatternActionRule>();
    }

    public InflectionRule(String ruleName) {
        this();
        this.setName(ruleName);
    }

    public InflectionRule(String ruleName, boolean applyUmlaut) {
        this();
        this.setName(ruleName);
        this.setApplyUmlaut(applyUmlaut);
    }

    public InflectionRule(String ruleName, PatternActionRule defRule) {
        this(ruleName);
        this.setDefaultRule(defRule);
    }

    public InflectionRule(String ruleName, PatternActionRule defRule, PatternActionRule ... ruleSet) {
        this(ruleName, defRule);
        this.setExceptionRules(ruleSet);
    }

    public InflectionRule(String ruleName, boolean applyUmlaut, PatternActionRule defRule) {
        this(ruleName, defRule);
        this.setApplyUmlaut(applyUmlaut);
    }

    public InflectionRule(String ruleName, boolean applyUmlaut, PatternActionRule defRule, PatternActionRule ... ruleSet) {
        this(ruleName, defRule);
        this.setExceptionRules(ruleSet);
        this.setApplyUmlaut(applyUmlaut);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public boolean hasName() {
        return this.name != null;
    }

    public void setApplyUmlaut(boolean consUmlaut) {
        this.umlaut = consUmlaut;
    }

    public boolean appliesUmlaut() {
        return this.umlaut;
    }

    public void addExceptionRules(PatternActionRule ... rules) {
        this.addExceptionRules(Arrays.asList(rules));
    }

    public void addExceptionRules(Collection<PatternActionRule> rules) {
        this.patternActionRules.addAll(rules);
        Collections.sort(this.patternActionRules);
    }

    public void setExceptionRules(PatternActionRule ... actionRules) {
        this.patternActionRules.clear();
        this.addExceptionRules(actionRules);
    }

    public void setExceptionRules(Collection<PatternActionRule> actionRules) {
        this.patternActionRules.clear();
        this.addExceptionRules(actionRules);
    }

    public int getNumberOfRules() {
        return this.patternActionRules.size();
    }

    public void setDefaultRule(PatternActionRule defRule) {
        this.defaultRule = defRule;
    }

    @Override
    public String apply(T lex) {
        String result;
        String base = "";
        base = lex instanceof Verb ? ((Verb)lex).getBaseform(false) : ((Word)lex).getBaseForm();
        if (!((Word)lex).hasInflectionType()) {
            return this.apply(base);
        }
        switch (1.$SwitchMap$simplenlg$features$InflectionType[((Word)lex).getInflectionType().ordinal()]) {
            case 1: 
            case 2: {
                result = base;
                break;
            }
            case 3: {
                result = this.defaultRule.fire(base);
                break;
            }
            case 4: {
                if (this.umlaut) {
                    result = this.defaultRule.fire(this.doubleFinalConsonant(base));
                    break;
                }
                result = this.defaultRule.fire(base);
                break;
            }
            default: {
                result = this.apply(base);
            }
        }
        return result;
    }

    @Override
    public String apply(String word) {
        this.wordMatcher.reset(word);
        if (!this.wordMatcher.matches()) {
            return word;
        }
        if (WordLists.MODALS.contains(word)) {
            return word;
        }
        if (this.appliesUmlaut()) {
            word = this.applyUmlaut(word);
        }
        String result = null;
        for (PatternActionRule currentRule : this.patternActionRules) {
            if (!currentRule.applies(word)) continue;
            result = currentRule.fire(word);
            break;
        }
        if (result == null && this.defaultRule != null) {
            result = this.defaultRule.fire(word);
        }
        return result;
    }

    private String doubleFinalConsonant(String word) {
        StringBuffer buffer = new StringBuffer(word);
        buffer.append(buffer.charAt(buffer.length() - 1));
        return buffer.toString();
    }

    private String applyUmlaut(String word) {
        Pattern p = Pattern.compile("(Au|Aa|au|aa|[aouAOU])[^aouAOU]*$");
        Matcher m = p.matcher(word);
        StringBuilder s = new StringBuilder(word);
        if (m.find()) {
            s.replace(m.start(1), m.end(1), this.createUmlaut(m.group(1)));
        }
        return s.toString();
    }

    private String createUmlaut(String vowel) {
        String umlaut = vowel;
        if (vowel.equals("a")) {
            umlaut = "\u00e4";
        } else if (vowel.equals("A")) {
            umlaut = "\u00c4";
        } else if (vowel.equals("o")) {
            umlaut = "\u00f6";
        } else if (vowel.equals("O")) {
            umlaut = "\u00d6";
        } else if (vowel.equals("u")) {
            umlaut = "\u00fc";
        } else if (vowel.equals("U")) {
            umlaut = "\u00dc";
        } else if (vowel.equals("au")) {
            umlaut = "\u00e4u";
        } else if (vowel.equals("Au")) {
            umlaut = "\u00c4u";
        } else if (vowel.equals("aa")) {
            umlaut = "\u00e4";
        } else if (vowel.equals("Aa")) {
            umlaut = "\u00c4";
        }
        return umlaut;
    }
}

