/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Adverb;
import simplenlg.lexicon.lexicalitems.Complementiser;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.lexicalitems.Word;
import simplenlg.realiser.AdjPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.SPhraseSpec;

public class NLGFactory {
    private Lexicon lexicon;

    public NLGFactory() {
        this(null);
    }

    public NLGFactory(Lexicon newLexicon) {
        this.setLexicon(newLexicon);
    }

    public Lexicon getLexicon() {
        return this.lexicon;
    }

    public void setLexicon(Lexicon lexicon) {
        this.lexicon = lexicon;
    }

    public LexicalItem createWord(String word, Category cat) {
        LexicalItem item = null;
        if (this.lexicon != null) {
            if (word.contains("|") || word.contains(" ")) {
                if (cat.equals((Object)Category.NOUN)) {
                    item = this.lexicon.getCompoundNoun(word);
                } else if (cat.equals((Object)Category.VERB)) {
                    item = this.lexicon.getComplexVerb(word);
                }
            } else if (cat.equals((Object)Category.PRONOUN)) {
                item = Constants.getPronoun(word);
            }
            if (item == null) {
                item = this.lexicon.getItem(cat, word);
            }
        }
        if (item == null) {
            switch (cat) {
                case ADJECTIVE: {
                    return new Adjective(word);
                }
                case ADVERB: {
                    return new Adverb(word);
                }
                case VERB: {
                    return new Verb(word);
                }
                case NOUN: {
                    return new Noun(word);
                }
                case PREPOSITION: {
                    return new Preposition(word);
                }
                case PRONOUN: {
                    return new Pronoun(word);
                }
                case DETERMINER: {
                    return new Determiner(word);
                }
                case COMPLEMENTISER: {
                    return new Complementiser(word);
                }
                case CONJUNCTION: {
                    return new Conjunction(word);
                }
            }
        }
        return item;
    }

    public Noun createNoun(String word) {
        return (Noun)this.createWord(word, Category.NOUN);
    }

    public Verb createVerb(String word) {
        return (Verb)this.createWord(word, Category.VERB);
    }

    public NPPhraseSpec createNounPhrase(String noun) {
        if (noun.indexOf(" ") > -1) {
            String spec = noun.substring(0, noun.indexOf(" "));
            String head = noun.substring(noun.indexOf(" ") + 1);
            if (Constants.getDeterminer(spec) != null || Constants.getPronoun(spec) != null) {
                return this.createNounPhrase((Object)spec, head);
            }
        }
        if (noun.indexOf("|") > -1) {
            Noun n = this.lexicon.getCompoundNoun(noun);
            return new NPPhraseSpec(n);
        }
        Pronoun pro = Constants.getPronoun(noun);
        if (pro != null) {
            return this.createPronounPhrase(pro);
        }
        Noun n = this.createNoun(noun);
        if (n != null) {
            return new NPPhraseSpec(n);
        }
        return new NPPhraseSpec(noun);
    }

    public NPPhraseSpec createNounPhrase(Object spec, String noun) {
        NPPhraseSpec np = this.createNounPhrase(noun);
        Word sp = null;
        if (spec instanceof String && (sp = Constants.getDeterminer((String)spec)) == null && (sp = Constants.getPronoun((String)spec)) != null && Constants.requiresPlural((Pronoun)sp)) {
            np.setPlural(true);
        }
        if (sp != null) {
            np.setSpecifier(sp);
        } else {
            np.setSpecifier(spec);
        }
        return np;
    }

    public NPPhraseSpec createNounPhrase(Object spec, Noun noun) {
        NPPhraseSpec np = new NPPhraseSpec(noun);
        Word sp = null;
        if (spec instanceof String && (sp = Constants.getDeterminer((String)spec)) == null && (sp = Constants.getPronoun((String)spec)) != null && Constants.requiresPlural((Pronoun)sp)) {
            np.setPlural(true);
        }
        if (sp != null) {
            np.setSpecifier(sp);
        } else {
            np.setSpecifier(spec);
        }
        return np;
    }

    public NPPhraseSpec createReferentialNounPhrase(NPPhraseSpec ref) {
        return new NPPhraseSpec(ref);
    }

    public NPPhraseSpec createReferentialNounPhrase(NPPhraseSpec ref, String pronoun) {
        Pronoun pro = Constants.getPronoun(pronoun);
        if (pro != null) {
            return new NPPhraseSpec(ref, pro);
        }
        return new NPPhraseSpec(ref, new Pronoun(pronoun));
    }

    public NPPhraseSpec createPronounPhrase(String pro) {
        Pronoun p = Constants.getPronoun(pro);
        if (p != null) {
            return this.createPronounPhrase(p);
        }
        return new NPPhraseSpec(pro);
    }

    public NPPhraseSpec createPronounPhrase(Pronoun pro) {
        NPPhraseSpec np = new NPPhraseSpec(pro);
        np.setPerson(pro.getPerson());
        if (Constants.requiresPlural(pro)) {
            np.setPlural(true);
        }
        return np;
    }

    public NPPhraseSpec createPossessivePronounPhrase(Person p, NumberAgr n) {
        NPPhraseSpec np = new NPPhraseSpec(Constants.getPossessivePronoun(p, n));
        return np;
    }

    public NPPhraseSpec createPersonalPronounPhrase(Person p, NumberAgr n) {
        NPPhraseSpec np = new NPPhraseSpec(Constants.getPersonalPronoun(p));
        if (n == NumberAgr.PLURAL) {
            np.setPlural(true);
        }
        return np;
    }

    public NPPhraseSpec createPersonalPronounPhrase(Person p, NumberAgr n, Gender g) {
        NPPhraseSpec np = this.createPersonalPronounPhrase(p, n);
        np.setGender(g);
        return np;
    }

    public PPPhraseSpec createPrepositionalPhrase(Object prep, Object np) {
        Phrase comp;
        Preposition p;
        if (prep instanceof String) {
            p = Constants.getPreposition((String)prep);
        } else if (prep instanceof Preposition) {
            p = (Preposition)prep;
        } else {
            return null;
        }
        if (np instanceof String) {
            comp = this.createNounPhrase((String)np);
        } else if (np instanceof Phrase) {
            comp = (Phrase)np;
        } else {
            return null;
        }
        return new PPPhraseSpec(p, comp);
    }

    public PPPhraseSpec createPrepositionalPhrase(String prep, Object np, Case c) {
        Preposition p = new Preposition(prep, c);
        return this.createPrepositionalPhrase(p, np);
    }

    public PPPhraseSpec createPrepositionalPhrase(String prep, Object np, boolean postpos) {
        Preposition p = Constants.getPostposition(prep);
        return this.createPrepositionalPhrase(p, np);
    }

    public PPPhraseSpec createPrepositionalPhrase(Object prep, Object spec, String noun) {
        return this.createPrepositionalPhrase(prep, this.createNounPhrase(spec, noun));
    }

    public PPPhraseSpec createPrepositionalPhrase(String prep, Object spec, String noun, Case c) {
        return this.createPrepositionalPhrase(prep, (Object)this.createNounPhrase(spec, noun), c);
    }

    public AdjPhraseSpec createAdjectivePhrase(String adj) {
        Adjective a = this.lexicon.getAdjective(adj);
        if (a == null) {
            return new AdjPhraseSpec(adj);
        }
        return new AdjPhraseSpec(a);
    }

    public SPhraseSpec createSentence(Object verb) {
        return this.createSentence(new NPPhraseSpec(Constants.PRO_EXPLETIVE), verb);
    }

    public SPhraseSpec createSentence(Object subj, Object verb) {
        Object v;
        Object s = subj;
        if (subj instanceof String) {
            s = this.createNounPhrase((String)subj);
        }
        if ((v = verb) instanceof String) {
            v = this.lexicon.getComplexVerb((String)v);
        }
        if (v == null) {
            v = verb;
        }
        return new SPhraseSpec(s, v);
    }

    public SPhraseSpec createSentence(Object subj, Object verb, Object comp) {
        SPhraseSpec s = this.createSentence(subj, verb);
        Object c = comp;
        if (c instanceof String) {
            c = this.createNounPhrase((String)comp);
        }
        s.setComplement(c);
        return s;
    }
}

