
def is_span_overlap_span(s1, s2):
    return not (s1[1] <= s2[0] or s2[1] <= s1[0])


def spans_flip(spans, beg, end):
    if len(spans) == 0:
        return [(beg, end)]
    new_spans = []
    if beg < spans[0][0] - 1:
        new_spans.append((beg, spans[0][0] - 1))
    i, n = 1, len(spans)
    while i < n:
        new_spans.append((spans[i - 1][1] + 1, spans[i][0] - 1))
        i += 1
    if end > spans[-1][1] + 1:
        new_spans.append((spans[-1][1] + 1, end))
    return new_spans


def spans_add(spans, span):
    s, n = 0, len(spans)
    new_spans = []
    while s < n and span[0] > spans[s][1] + 1:
        new_spans.append(spans[s])
        s += 1
    e = s
    while e < n and span[1] >= spans[e][0] - 1:
        e += 1
    span_beg, span_end = span[0], span[1]
    if s != n:
        span_beg = min(span_beg, spans[s][0])
    if e - 1 != n and e != s:
        span_end = max(span_end, spans[e - 1][1])
    new_spans.append((span_beg, span_end))
    while e < n:
        new_spans.append(spans[e])
        e += 1
    return new_spans


def spans_in_span(spans, span, key=lambda x: x):
    s, n = 0, len(spans)
    while s < n and key(spans[s])[0] < span[0]:
        s += 1
    e = s
    while e < n and \
            key(spans[e])[0] >= span[0] and key(spans[e])[1] <= span[1]:
        e += 1
    if s == e:
        return []
    else:
        return spans[s:e]
