/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class FileFilters {
    public static final FileFilter trivialFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return true;
        }
    };
    public static final FileFilter ccgAUTOFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String fileName = file.getName();
            return fileName.endsWith(".fid") || fileName.endsWith(".auto");
        }
    };

    private FileFilters() {
    }

    public static FileFilter sectionFileFilter() {
        return new SectionFileFilter();
    }

    public static FileFilter sectionFileFilter(String section) {
        return new SectionFileFilter(section);
    }

    public static FileFilter textFileFilter(String textFilePath) {
        return new TextFileFilter(textFilePath);
    }

    public static FileFilter numberRangeFileFilter(String extension, int lowFileNum, int highFileNum, boolean recurse) {
        return new NumberRangeFileFilter(extension, lowFileNum, highFileNum, recurse);
    }

    public static FileFilter nameSuffixFileFilter(String suffix) {
        return new NameSuffixFileFilter(suffix);
    }

    private static class NameSuffixFileFilter
    implements FileFilter {
        String suffix;

        NameSuffixFileFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(this.suffix);
        }
    }

    private static class NumberRangeFileFilter
    implements FileFilter {
        int highFileNum;
        int lowFileNum;
        String extension;
        boolean recurse;

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return this.recurse;
            }
            String name = pathname.getName();
            if (!name.endsWith(this.extension)) {
                return false;
            }
            int lastNumberIndex = this.getLastNumberIndex(name);
            if (lastNumberIndex == -1) {
                return false;
            }
            int numEndLoc = lastNumberIndex + 1;
            int numStartLoc = this.getLastNonNumberIndex(name, lastNumberIndex) + 1;
            int fileNum = Integer.parseInt(name.substring(numStartLoc, numEndLoc));
            return fileNum >= this.lowFileNum && fileNum <= this.highFileNum;
        }

        private int getLastNonNumberIndex(String name, int lastNumberIndex) {
            int index = lastNumberIndex - 1;
            while (index >= 0 && Character.isDigit(name.charAt(index))) {
                --index;
            }
            if (index < -1) {
                return -1;
            }
            return index;
        }

        private int getLastNumberIndex(String name) {
            int index = name.length() - 1;
            while (index >= 0 && !Character.isDigit(name.charAt(index))) {
                --index;
            }
            return index;
        }

        NumberRangeFileFilter(String extension, int lowFileNum, int highFileNum, boolean recurse) {
            this.highFileNum = highFileNum;
            this.lowFileNum = lowFileNum;
            this.extension = extension;
            this.recurse = recurse;
        }
    }

    private static class SectionFileFilter
    implements FileFilter {
        String sections;
        int low = Integer.MIN_VALUE;
        int high = Integer.MAX_VALUE;

        SectionFileFilter() {
            this("all");
        }

        SectionFileFilter(String sections) {
            this.sections = sections;
            this.parseSections();
        }

        private void parseSections() {
            if ("all".equals(this.sections)) {
                return;
            }
            if (this.sections.matches("[0-9]+")) {
                this.high = this.low = Integer.parseInt(this.sections);
                return;
            }
            String[] low_high = this.sections.split("-");
            this.low = Integer.parseInt(low_high[0]);
            this.high = Integer.parseInt(low_high[1]);
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String parentName = file.getParentFile().getName();
            if (SectionFileFilter.isNumeric(parentName)) {
                int section = Integer.parseInt(parentName);
                return section >= this.low && section <= this.high;
            }
            return false;
        }

        private static boolean isNumeric(String str) {
            int i = str.length();
            while (--i >= 0) {
                if (Character.isDigit(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class TextFileFilter
    implements FileFilter {
        File textFile;
        BufferedReader br;
        List<String> fileNames = new ArrayList<String>();
        boolean recurse = true;

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return this.recurse;
            }
            String fileName = pathname.getName();
            for (String str : this.fileNames) {
                if (!str.contains(fileName)) continue;
                return true;
            }
            return false;
        }

        TextFileFilter(String textFilePath) {
            this.textFile = new File(textFilePath);
            try {
                this.br = new BufferedReader(new FileReader(this.textFile));
                String str = this.br.readLine();
                while (str != null) {
                    this.fileNames.add(str);
                    str = this.br.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

