///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "TextObsVars.h"
#include "HHMMLangModel-gf.h"
#include "TextObsModel.h"

#include "SyntacticLMState.h"

#include <iostream>
#include <string>

using namespace std;

int main (int nArgs, char* argv[]) {
  
  int beamSize=200;

  SyntacticLMModelFiles<HModel,OModel>* modelData = new SyntacticLMModelFiles<HModel,OModel>(nArgs, argv);

  SyntacticLMState<HModel,OModel,S,R>* prev = NULL;
  SyntacticLMState<HModel,OModel,S,R>* curr = new SyntacticLMState<HModel,OModel,S,R>( modelData, beamSize );
  
  cerr << "Awaiting user input:" << endl;
  for (string word; cin >> word; ) {
	cerr << "\tRead:\t" << word << endl;
	cerr << "\tDeleting prev" << endl;
	delete prev;
	cerr << "\tSetting prev=curr" << endl;
	prev = curr;
	cerr << "\tConstructing new LM state from prev and word: " << word << endl;
	curr = new SyntacticLMState<HModel,OModel,S,R>(prev, word);
	cerr << "\tDoes curr==NULL?\t" << (curr==NULL) << endl;
	cerr << "\tScore:\t" << curr->getScore() << endl;
	cerr << "\tReady to read next word" << endl;
	
  }
  
  delete prev;
  delete curr;
  delete modelData;
  
}
