/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.time;

import babel.content.corpora.accessors.CorpusAccessor;
import babel.content.corpora.accessors.TemporalCorpusAccessor;
import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.PropertyCollector;
import babel.content.eqclasses.properties.time.TimeDistribution;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeDistributionCollector
extends PropertyCollector {
    protected static final Log LOG = LogFactory.getLog(TimeDistributionCollector.class);
    protected HashSet<Integer> m_binIdxs = new HashSet();

    public TimeDistributionCollector(boolean caseSensitive) throws Exception {
        super(caseSensitive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collectProperty(CorpusAccessor corpusAccess, Set<? extends EquivalenceClass> eqs) throws Exception {
        if (!(corpusAccess instanceof TemporalCorpusAccessor)) {
            throw new IllegalArgumentException("Did not supply a TemporalCorpusAccessor");
        }
        TemporalCorpusAccessor temporalAccess = (TemporalCorpusAccessor)corpusAccess;
        HashMap<String, EquivalenceClass> eqsMap = new HashMap<String, EquivalenceClass>(eqs.size());
        for (EquivalenceClass equivalenceClass : eqs) {
            for (String word : equivalenceClass.getAllWords()) {
                assert (eqsMap.get(word) == null);
                eqsMap.put(word, equivalenceClass);
            }
        }
        for (EquivalenceClass equivalenceClass : eqs) {
            equivalenceClass.setProperty(new TimeDistribution());
        }
        this.m_binIdxs.clear();
        temporalAccess.resetDays();
        boolean bl = false;
        while (temporalAccess.nextDay()) {
            void var5_10;
            if (this.recordCurDayCounts((int)var5_10, this.getCurDayCounts(temporalAccess, eqsMap))) {
                this.m_binIdxs.add((int)var5_10);
            }
            ++var5_10;
        }
    }

    public Set<Integer> binsCollected() {
        return this.m_binIdxs;
    }

    protected boolean recordCurDayCounts(int curDayIdx, HashMap<EquivalenceClass, Integer> curDayCounts) {
        if (curDayCounts != null && curDayCounts.size() > 0) {
            for (EquivalenceClass eq : curDayCounts.keySet()) {
                ((TimeDistribution)eq.getProperty(TimeDistribution.class.getName())).addBin(curDayIdx, curDayCounts.get(eq));
            }
        }
        return curDayCounts != null && curDayCounts.size() > 0;
    }

    protected HashMap<EquivalenceClass, Integer> getCurDayCounts(TemporalCorpusAccessor temporalAccess, HashMap<String, EquivalenceClass> eqsMap) throws Exception {
        HashMap<EquivalenceClass, Integer> counts = null;
        BufferedReader reader = new BufferedReader(temporalAccess.getCurDayReader());
        if (reader != null && reader.ready()) {
            String curLine;
            counts = new HashMap<EquivalenceClass, Integer>();
            while ((curLine = reader.readLine()) != null) {
                String[] curTokens = curLine.split("[\\|\\$\\*\\s\"'\\-\\+=,;:\u00ac\u00b4\u00ac\u00aa{}()<>\\[\\]\\.\\?\u00ac\u00f8!\u00ac\u00b0\u201a\u00c4\u00ec\u201a\u00c4\u00fa\u201a\u00c4\u00f9\u201a\u00c4\u00f2\u201a\u00c4\u00f4\u00ac\u2020]+");
                int numToken = 0;
                while (numToken < curTokens.length) {
                    String word = EquivalenceClass.getWordOfAppropriateForm(curTokens[numToken], this.m_caseSensitive);
                    EquivalenceClass curEq = eqsMap.get(word);
                    if (curEq != null) {
                        Integer count = (Integer)counts.get(curEq);
                        counts.put(curEq, count == null ? 1 : count + 1);
                    }
                    ++numToken;
                }
            }
            reader.close();
        }
        return counts;
    }
}

