package org.maltparser.parser.algorithm.twoplanar3T;

import org.maltparser.core.exception.MaltChainedException;

import org.maltparser.parser.Algorithm;
import org.maltparser.parser.TransitionSystem;
import org.maltparser.parser.guide.OracleGuide;
import org.maltparser.parser.history.GuideUserHistory;

public class TwoPlanar3TArcEagerFactory extends TwoPlanar3TFactory {
	public TwoPlanar3TArcEagerFactory(Algorithm algorithm) {
		super(algorithm);
	}
	
	public TransitionSystem makeTransitionSystem() throws MaltChainedException {
		if (manager.getConfigLogger().isInfoEnabled()) {
			manager.getConfigLogger().info("  Transition system    : 2 Planar 3T Label Strategy Arc-Eager\n");
		}
		TransitionSystem ts = new TwoPlanar3T();
		ts.setPropagationManager(manager.getPropagationManager());
		return ts;
	}
	
	public OracleGuide makeOracleGuide(GuideUserHistory history) throws MaltChainedException {
		if (manager.getConfigLogger().isInfoEnabled()) {
			manager.getConfigLogger().info("  Oracle               : 2 Planar 3T Label Strategy Arc-Eager\n");
		}
		return new TwoPlanar3TArcEagerOracle(manager, history);
	}
}