package org.maltparser.parser.algorithm.planar3T;


import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;

public abstract class Planar3TFactory implements AbstractParserFactory {
	protected Algorithm algorithm;
	protected DependencyParserConfig manager;
	
	public Planar3TFactory(Algorithm algorithm) {
		setAlgorithm(algorithm);
		setManager(algorithm.getManager());
	}
	
	public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
		if (manager.getConfigLogger().isInfoEnabled()) {
			manager.getConfigLogger().info("  Parser configuration : Planar 3T with no_covered_roots = " + manager.getOptionValue("planar3t", "no_covered_roots").toString().toUpperCase() + ", " + "acyclicity = " + manager.getOptionValue("planar3t", "acyclicity").toString().toUpperCase() + ", connectedness = " + manager.getOptionValue("planar3t", "connectedness").toString().toUpperCase() + ", " + "root handling = "+manager.getOptionValue("planar3t" , "planar_root_handling").toString().toUpperCase() +"\n");
		}
		return new Planar3TConfig(manager.getSymbolTables() , manager.getOptionValue("planar3t", "no_covered_roots").toString() , manager.getOptionValue("planar3t", "acyclicity").toString() , manager.getOptionValue("planar3t", "connectedness").toString(), manager.getOptionValue("planar3t" , "planar_root_handling").toString());
	}
	
	public Function makeFunction(String subFunctionName) throws MaltChainedException {
		return new Planar3TAddressFunction(subFunctionName, algorithm);
	}

	public Algorithm getAlgorithm() {
		return algorithm;
	}

	public void setAlgorithm(Algorithm algorithm) {
		this.algorithm = algorithm;
	}

	public DependencyParserConfig getManager() {
		return manager;
	}

	public void setManager(DependencyParserConfig manager) {
		this.manager = manager;
	}
}
