package szte.csd.indicatorsel;

import java.util.Map;

/**
 * 
 * The conditonal entropy indicator evaluator.
 * H(C|W) = H(C,W)/H(C) = [SUM SUM p(c,w)*log( p(c|w)] / SUM p(c)
 * where C \in {POS,NEG} the classes and W \in {w present,w not present} 
 *
 */
public class CondEntropyIndicatorSelector extends InformtaionTheoryIndicatorSelection {
  public double calcFeatureScore(Map<Boolean, Double> df, Map<Boolean, Double> n) {
    // H(C,W) = SUM SUM p(c,w)*log( p(c|w)
    double size= n.get(true)+n.get(false); 
    double pcw = df.get(true)/size;
    double pw  = (df.get(true)+df.get(false))/size;
    double HCW = safeentropy(pcw,pcw/pw);
           pcw = df.get(false)/size;
           HCW += safeentropy(pcw,pcw/pw);
           pcw = (n.get(false)-df.get(false))/size;
           HCW += safeentropy(pcw,pcw/(1.0-pw));
           pcw = (n.get(true)-df.get(true))/size;
           HCW += safeentropy(pcw,pcw/(1.0-pw));
    // H(C)
     double pc = n.get(true)/size;
     double HC = pc*Math.log(pc) + (1.0-pc)*Math.log(1.0-pc);
     
     if(1.0-HCW/HC>1.0 || 1.0-HCW/HC<0.0)
       System.err.println("HCW="+(1.0-HCW/HC));

     return 1.0-HCW/HC;
  }
}
