function [tMin,fMin,Q2Flip,output]=essential_distMinAngle(Q1,Q2,varargin)
NQ1=size(Q1,3);
NQ2=size(Q2,3);

if NQ1==1 && NQ2>1
    Q1=repmat(Q1,[1 1 NQ2]);
    NQ1=NQ2;
end
if NQ1>1 && NQ2==1
    Q2=repmat(Q2,[1 1 NQ1]);
end

if NQ1>1
    tMin=zeros(NQ1,1);
    fMin=zeros(NQ1,1);
    Q2Flip=zeros(6,3,NQ1);
    if nargout>3
        output=repmat(struct('tMin',[],'fMin',[],'tBreak1',[],'tBreak2',[]),NQ1,1);
    end
    for iQ=1:NQ1
        if nargout>3
            [tMin(iQ),fMin(iQ),Q2Flip(:,:,iQ),output(iQ)]=...
                essential_distMinAngle(Q1(:,:,iQ),Q2(:,:,iQ),varargin{:});
        else
            [tMin(iQ),fMin(iQ),Q2Flip(:,:,iQ)]=...
                essential_distMinAngle(Q1(:,:,iQ),Q2(:,:,iQ),varargin{:});
        end
    end
else
    flagModTMin=false;
    flagSigned=false;

    %optional parameters
    ivarargin=1;
    while(ivarargin<=length(varargin))
        switch(lower(varargin{ivarargin}))
            case 'flagmodtmin'
                ivarargin=ivarargin+1;
                flagModTMin=varargin{ivarargin};
            case 'signed'
                flagSigned=true;
            case 'flagsigned'
                ivarargin=ivarargin+1;
                flagSigned=varargin{ivarargin};
            otherwise
                    error(['Argument ' varargin{ivarargin} ' not valid!'])
        end
        ivarargin=ivarargin+1;
    end

    tMin=zeros(4,1);
    fMin=zeros(4,1);
    tBreak1=zeros(4,1);
    tBreak2=zeros(4,1);
    Q2Flip=zeros(6,3,4);
    if ~flagSigned
        for k=1:4
            [tMin(k),fMin(k),tBreak1(k),tBreak2(k),Q2Flip(:,:,k)]=...
                essential_distMinAnglePair(Q1,Q2,k);
        end
    else
        [tMin,fMin,tBreak1,tBreak2,Q2Flip]=...
            essential_distMinAnglePair(Q1,Q2,1);
    end    

    if flagModTMin
        tMin=modAngle(tMin);
    end

    if nargout>3
        output.tMin=tMin;
        output.fMin=fMin;
        output.tBreak1=tBreak1;
        output.tBreak2=tBreak2;
    end

    if ~flagSigned
        [fMin,idxMin]=min(fMin);
        fMin=max(fMin,0);
        tMin=tMin(idxMin);
        Q2Flip=Q2Flip(:,:,idxMin);
        if nargout>3
            output.idxMin=idxMin;
        end
    end
end