function candoit = canGetGradient(problem)
% Checks whether the gradient can be computed for a problem structure.
% 
% function candoit = canGetGradient(problem)
%
% Returns true if the gradient of the cost function can be computed given
% the problem description, false otherwise.
%
% See also: canGetCost canGetDirectionalDerivative canGetHessian

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, Dec. 30, 2012.
% Contributors: 
% Change log: 
%
%   June 28, 2016 (NB):
%       Added support for getPartialGradient
%
%   Nov. 1, 2016 (NB):
%       Added support for gradient from directional derivatives

    candoit = isfield(problem, 'grad') || isfield(problem, 'costgrad') || ...
              canGetEuclideanGradient(problem) || ...
              canGetPartialGradient(problem) || ...
              ... % Check if directional derivatives can be obtained, since
              ... % it is possible to compute the gradient from directional
              ... % derivatives (expensively). Here, it is not possible to
              ... % call canGetDirectionalDerivative, because that function
              ... % would then potentially call canGetGradient, thus 
              ... % starting an infinite loop. As a result, we have some
              ... % code redundancy: the check below needs to be kept
              ... % equivalent to the check in canGetDirectionalDerivative.
              isfield(problem, 'diff');
    
end
