/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.morph;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NounInflection {
    public static String applyUmlaut(String word) {
        Pattern p = Pattern.compile("(Au|Aa|au|aa|[aouAOU])[^aouAOU]*$");
        Matcher m = p.matcher(word);
        StringBuilder s = new StringBuilder(word);
        if (m.find()) {
            s.replace(m.start(1), m.end(1), NounInflection.createUmlaut(m.group(1)));
        }
        return s.toString();
    }

    private static String createUmlaut(String vowel) {
        String umlaut = vowel;
        if (vowel.equals("a")) {
            umlaut = "\u00e4";
        } else if (vowel.equals("A")) {
            umlaut = "\u00c4";
        } else if (vowel.equals("o")) {
            umlaut = "\u00f6";
        } else if (vowel.equals("O")) {
            umlaut = "\u00d6";
        } else if (vowel.equals("u")) {
            umlaut = "\u00fc";
        } else if (vowel.equals("U")) {
            umlaut = "\u00dc";
        } else if (vowel.equals("au")) {
            umlaut = "\u00e4u";
        } else if (vowel.equals("Au")) {
            umlaut = "\u00c4u";
        } else if (vowel.equals("aa")) {
            umlaut = "\u00e4";
        } else if (vowel.equals("Aa")) {
            umlaut = "\u00c4";
        }
        return umlaut;
    }

    public static String convertFinalEszet(String word) {
        if (word.endsWith("\u00df")) {
            return word.substring(0, word.length() - 1).concat("s");
        }
        return word;
    }
}

