/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.morph;

import simplenlg.features.AdjectiveDegree;
import simplenlg.features.AdjectiveType;
import simplenlg.features.Case;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.lexicon.morph.AdjectiveInflection;
import simplenlg.lexicon.morph.InflectionPattern;

public class AdjectiveInflection {
    public static final InflectionPattern<Adjective> WEAK_INFLECTION = new InflectionPattern(new String[]{"e", "en", "en", "en"}, new String[]{"e", "e", "en", "en"}, new String[]{"e", "e", "en", "en"}, new String[]{"en", "en", "en", "en"});
    public static final InflectionPattern<Adjective> STRONG_INFLECTION = new InflectionPattern(new String[]{"er", "en", "en", "em"}, new String[]{"e", "e", "er", "er"}, new String[]{"es", "es", "en", "em"}, new String[]{"e", "e", "er", "en"});
    public static final InflectionPattern<Adjective> MIXED_INFLECTION = new InflectionPattern(new String[]{"er", "en", "en", "en"}, new String[]{"e", "e", "en", "en"}, new String[]{"es", "es", "en", "en"}, new String[]{"en", "en", "en", "en"});

    public static final String getForm(Adjective a, Case c, NumberAgr n, Gender g, AdjectiveType t, AdjectiveDegree d) {
        String stem;
        switch (1.$SwitchMap$simplenlg$features$AdjectiveDegree[d.ordinal()]) {
            default: {
                stem = a.getPositive();
                break;
            }
            case 2: {
                stem = a.getComparative();
                break;
            }
            case 3: {
                stem = a.getSuperlative();
            }
        }
        if (t == AdjectiveType.UNINFLECTED) {
            if (d == AdjectiveDegree.SUPERLATIVE) {
                return "am " + stem + "n";
            }
            return stem;
        }
        if (d == AdjectiveDegree.POSITIVE && a.isElideFinalE()) {
            stem = AdjectiveInflection.elideFinalE(stem);
        }
        if (stem.matches(".*e$")) {
            stem = stem.substring(0, stem.length() - 1);
        }
        switch (1.$SwitchMap$simplenlg$features$AdjectiveType[t.ordinal()]) {
            default: {
                return STRONG_INFLECTION.apply(stem, c, n, g);
            }
            case 2: {
                return WEAK_INFLECTION.apply(stem, c, n, g);
            }
            case 3: 
        }
        return MIXED_INFLECTION.apply(stem, c, n, g);
    }

    public static final AdjectiveType determineAdjectiveType(Object spec, boolean plural) {
        AdjectiveType t = AdjectiveType.STRONG;
        if (spec != null) {
            if (spec instanceof Determiner) {
                t = ((Determiner)spec).getBaseForm().equals("ein") && plural ? AdjectiveType.STRONG : (((Determiner)spec).getBaseForm().endsWith("ein") ? AdjectiveType.MIXED : AdjectiveType.WEAK);
            } else if (spec instanceof Pronoun) {
                t = AdjectiveInflection.determineAdjectiveType((Pronoun)spec);
            }
        }
        return t;
    }

    public static final AdjectiveType determineAdjectiveType(Pronoun pro) {
        String baseform = pro.getBaseForm();
        if (baseform.equals("derselbe") || baseform.equals("derjenige") || baseform.equals("dies") || baseform.equals("jen") || baseform.equals("jed") || baseform.equals("jedwed") || baseform.equals("jeglich") || baseform.equals("alle") || baseform.equals("welch") || baseform.equals("manch") || baseform.equals("solch") || baseform.equals("beide")) {
            return AdjectiveType.WEAK;
        }
        if (baseform.equals("ein") || baseform.equals("irgendein") || baseform.equals("kein") || Constants.isPossessivePronoun(pro)) {
            return AdjectiveType.MIXED;
        }
        return AdjectiveType.STRONG;
    }

    public static final String elideFinalE(String base) {
        int i = base.lastIndexOf("e");
        if (i == -1) {
            return base;
        }
        return base.substring(0, i) + base.substring(i + 1);
    }
}

