/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Generics;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Filters {
    private Filters() {
    }

    public static <T> Filter<T> acceptFilter() {
        return new CategoricalFilter(true);
    }

    public static <T> Filter<T> rejectFilter() {
        return new CategoricalFilter(false);
    }

    public static <E> Filter<E> collectionAcceptFilter(E[] objs) {
        return new CollectionAcceptFilter<E>(Arrays.asList(objs), true);
    }

    public static <E> Filter<E> collectionAcceptFilter(Collection<E> objs) {
        return new CollectionAcceptFilter<E>(objs, true);
    }

    public static <E> Filter<E> collectionRejectFilter(E[] objs) {
        return new CollectionAcceptFilter<E>(Arrays.asList(objs), false);
    }

    public static <E> Filter<E> collectionRejectFilter(Collection<E> objs) {
        return new CollectionAcceptFilter<E>(objs, false);
    }

    public static <E> Filter<E> andFilter(Filter<E> f1, Filter<E> f2) {
        return new CombinedFilter<E>(f1, f2, true);
    }

    public static <E> Filter<E> orFilter(Filter<E> f1, Filter<E> f2) {
        return new CombinedFilter<E>(f1, f2, false);
    }

    public static <E> Filter<E> notFilter(Filter<E> filter) {
        return new NegatedFilter<E>(filter);
    }

    public static <E> Filter<E> switchedFilter(Filter<E> filter, boolean negated) {
        return new NegatedFilter<E>(filter, negated);
    }

    public static <E> E[] filter(E[] elems, Filter<E> filter) {
        ArrayList<E> filtered = new ArrayList<E>();
        for (E elem : elems) {
            if (!filter.accept(elem)) continue;
            filtered.add(elem);
        }
        return filtered.toArray((Object[])Array.newInstance(elems.getClass().getComponentType(), filtered.size()));
    }

    public static <E> void retainAll(Collection<E> elems, Filter<? super E> filter) {
        Iterator<E> iter = elems.iterator();
        while (iter.hasNext()) {
            E elem = iter.next();
            if (filter.accept(elem)) continue;
            iter.remove();
        }
    }

    public static class RandomFilter<E>
    implements Filter<E> {
        final Random random;
        final double fraction;

        public RandomFilter() {
            this(0.1, new Random());
        }

        public RandomFilter(double fraction) {
            this(fraction, new Random());
        }

        public RandomFilter(double fraction, Random random) {
            this.fraction = fraction;
            this.random = random;
        }

        @Override
        public boolean accept(E o) {
            return this.random.nextDouble() < this.fraction;
        }
    }

    private static class NegatedFilter<E>
    implements Filter<E> {
        private Filter<E> filter;
        private boolean negated;
        private static final long serialVersionUID = -1599556783677718177L;

        public NegatedFilter(Filter<E> filter, boolean negated) {
            this.filter = filter;
            this.negated = negated;
        }

        public NegatedFilter(Filter<E> filter) {
            this(filter, true);
        }

        @Override
        public boolean accept(E o) {
            return this.negated ^ this.filter.accept(o);
        }

        public String toString() {
            return "NOT(" + this.filter.toString() + ")";
        }
    }

    public static class ConjFilter<T>
    implements Filter<T> {
        List<Filter<T>> filters;
        private static final long serialVersionUID = 1L;

        public ConjFilter(List<Filter<T>> filters) {
            this.filters = filters;
        }

        public ConjFilter(Filter<T> ... filters) {
            this.filters = new ArrayList<Filter<T>>();
            this.filters.addAll(Arrays.asList(filters));
        }

        public void addFilter(Filter<T> filter) {
            this.filters.add(filter);
        }

        @Override
        public boolean accept(T obj) {
            for (Filter<T> f : this.filters) {
                if (f.accept(obj)) continue;
                return false;
            }
            return true;
        }
    }

    public static class DisjFilter<T>
    implements Filter<T> {
        List<Filter<T>> filters;
        private static final long serialVersionUID = 1L;

        public DisjFilter(List<Filter<T>> filters) {
            this.filters = filters;
        }

        public DisjFilter(Filter<T> ... filters) {
            this.filters = new ArrayList<Filter<T>>();
            this.filters.addAll(Arrays.asList(filters));
        }

        public void addFilter(Filter<T> filter) {
            this.filters.add(filter);
        }

        @Override
        public boolean accept(T obj) {
            for (Filter<T> f : this.filters) {
                if (!f.accept(obj)) continue;
                return true;
            }
            return false;
        }
    }

    private static class CombinedFilter<E>
    implements Filter<E> {
        private Filter<E> f1;
        private Filter<E> f2;
        private boolean conjunction;
        private static final long serialVersionUID = -2988241258905198687L;

        public CombinedFilter(Filter<E> f1, Filter<E> f2, boolean conjunction) {
            this.f1 = f1;
            this.f2 = f2;
            this.conjunction = conjunction;
        }

        @Override
        public boolean accept(E o) {
            if (this.conjunction) {
                return this.f1.accept(o) && this.f2.accept(o);
            }
            return this.f1.accept(o) || this.f2.accept(o);
        }
    }

    private static final class CollectionAcceptFilter<E>
    implements Filter<E>,
    Serializable {
        private final Collection<E> args;
        private final boolean judgment;
        private static final long serialVersionUID = -8870550963937943540L;

        protected CollectionAcceptFilter(Collection<E> c, boolean judgment) {
            this.args = Generics.newHashSet(c);
            this.judgment = judgment;
        }

        @Override
        public boolean accept(E obj) {
            if (this.args.contains(obj)) {
                return this.judgment;
            }
            return !this.judgment;
        }

        public String toString() {
            return "(" + this.judgment + ":" + this.args + ")";
        }
    }

    private static final class CategoricalFilter<T>
    implements Filter<T> {
        private final boolean judgment;
        private static final long serialVersionUID = 7501774666726883656L;

        protected CategoricalFilter(boolean judgment) {
            this.judgment = judgment;
        }

        @Override
        public boolean accept(T obj) {
            return this.judgment;
        }

        public String toString() {
            return "CategoricalFilter(" + this.judgment + ")";
        }
    }
}

