#include "baseline_macros.h"
#include "io/token_manager.h"

namespace baseline {

int g_add_gold_answer_when_beam_is_empty = 0;
int g_beam_size = 1 << 7;

void printEdges(const EdsGraph& graph,
                std::unordered_map< EdsGraph::Arc,
                                    RuleSet::State >& edge_states) {
    for (auto& item : edge_states) {
        int src = ARC_SRC(item.first);
        int tar = ARC_TAR(item.first);
        int state = GET_STATE(item.second);
        std::cerr << '[' << graph.nodes[src] << '@' << src << " -> "
                  << graph.nodes[tar] << '@' << tar << " : "
                  << TokenManager::stateAt(state) << "] ";
    }
}
}
