similarityData <- read.table("~/DeepLearning/TransmatCorpus/Matrix/similarity_800vecs_150307.txt", sep=":", col.names=c("word","score"))
splitArray <- split(similarityData$score, ceiling(seq_along(similarityData$score)/20000))
avgArray <- lapply(splitArray, FUN = mean)
unlist(avgArray)
partArray <- avgArray[1:10]
xVec<-c(1:length(partArray))
yVec<-unlist(partArray)
plot(xVec,yVec)

set.seed(100)
# some starting values
b = 0.097982
c = -1.256162

data <- data.frame(xVec,yVec)
f <- function(x,b,c) {exp(-b*x + c)}
# do the fit
fit = nls(yVec ~ f(xVec,b,c), data = data, start=c(b=b,c=c))
# summarise
summary(fit)


new = data.frame(xVec = seq(min(xVec),max(xVec),len=600))
lines(new$xVec,predict(fit,newdata=new))