/*
 * Decompiled with CFR 0.152.
 */
package matetools.extractors;

import java.util.Arrays;
import matetools.is2.data.Cluster;
import matetools.is2.data.D4;
import matetools.is2.data.Instances;
import matetools.is2.data.Long2IntInterface;
import matetools.is2.data.MFB;
import matetools.is2.data.ParseNBest;
import matetools.is2.util.DB;

public final class ExtractorReranker {
    public static int s_rel;
    public static int s_word;
    public static int s_type;
    public static int s_dir;
    public static int s_dist;
    public static int s_feat;
    public static int s_child;
    public static int s_spath;
    public static int s_lpath;
    public static int s_pos;
    public static int d0;
    public static int d1;
    public static int d2;
    public static int d3;
    public static int d4;
    public static int d5;
    public static int d10;
    MFB mf;
    final D4 dl1;
    final D4 dl2;
    final D4 dwr;
    final D4 dr;
    final D4 dwwp;
    final D4 dw;
    final D4 dwp;
    final D4 dlf;
    final D4 d3lp;
    final D4 d2lp;
    final D4 d2pw;
    final D4 d2pp;
    public final Long2IntInterface li;
    public static final String REL = "REL";
    public static final String END = "END";
    public static final String STR = "STR";
    public static final String LA = "LA";
    public static final String RA = "RA";
    public static final String FEAT = "F";
    private static int ra;
    private static int la;
    private static int s_str;
    private static int s_end;
    private static int _cend;
    private static int _cstr;
    private static int s_stwrd;
    private static int s_relend;
    protected static final String TYPE = "TYPE";
    protected static final String DIR = "D";
    public static final String POS = "POS";
    protected static final String DIST = "DIST";
    protected static final String MID = "MID";
    private static final String _0 = "0";
    private static final String _4 = "4";
    private static final String _3 = "3";
    private static final String _2 = "2";
    private static final String _1 = "1";
    private static final String _5 = "5";
    private static final String _10 = "10";
    private static final String WORD = "WORD";
    private static final String STWRD = "STWRD";
    private static final String STPOS = "STPOS";
    private static int nofeat;
    public static int maxForm;
    public static final int _FC = 60;

    public ExtractorReranker(Long2IntInterface li) {
        this.li = li;
        this.dl1 = new D4(li);
        this.dl2 = new D4(li);
        this.dwr = new D4(li);
        this.dr = new D4(li);
        this.dwwp = new D4(li);
        this.dw = new D4(li);
        this.dwp = new D4(li);
        this.dlf = new D4(li);
        this.d3lp = new D4(li);
        this.d2lp = new D4(li);
        this.d2pw = new D4(li);
        this.d2pp = new D4(li);
    }

    public static void initStat() {
        DB.println("init called ");
        MFB mf = new MFB();
        s_rel = mf.getFeatureCounter().get(REL);
        s_pos = mf.getFeatureCounter().get(POS);
        s_word = mf.getFeatureCounter().get(WORD);
        s_type = mf.getFeatureCounter().get(TYPE);
        s_dir = mf.getFeatureCounter().get(DIR);
        la = mf.getValue(DIR, LA);
        ra = mf.getValue(DIR, RA);
        s_dist = mf.getFeatureCounter().get(DIST);
        s_feat = mf.getFeatureCounter().get(FEAT);
        s_spath = mf.getFeatureCounter().get("SP") == null ? 0 : mf.getFeatureCounter().get("SP");
        s_lpath = mf.getFeatureCounter().get("LP") == null ? 0 : mf.getFeatureCounter().get("LP");
    }

    public void init() {
        this.mf = new MFB();
        this.dl1.a0 = s_type;
        this.dl1.a1 = 3L;
        this.dl1.a2 = s_pos;
        this.dl1.a3 = s_pos;
        this.dl1.a4 = s_pos;
        this.dl1.a5 = s_pos;
        this.dl1.a6 = s_pos;
        this.dl1.a7 = s_pos;
        this.dl2.a0 = s_type;
        this.dl2.a1 = 3L;
        this.dl2.a2 = s_rel;
        this.dl2.a3 = s_rel;
        this.dl2.a4 = s_rel;
        this.dl2.a5 = s_rel;
        this.dl2.a6 = s_rel;
        this.dl2.a7 = s_rel;
        this.dl2.a8 = s_rel;
        this.dl2.a9 = s_rel;
        this.dwp.a0 = s_type;
        this.dwp.a1 = 3L;
        this.dwp.a2 = s_word;
        this.dwp.a3 = s_rel;
        this.dwp.a4 = s_rel;
        this.dwp.a5 = s_rel;
        this.dwp.a6 = s_rel;
        this.dwp.a7 = s_rel;
        this.dwwp.a0 = s_type;
        this.dwwp.a1 = 3L;
        this.dwwp.a2 = s_word;
        this.dwwp.a3 = s_word;
        this.dwwp.a4 = s_pos;
        this.dwwp.a5 = s_word;
        this.dwwp.a6 = s_pos;
        this.dwwp.a7 = s_pos;
    }

    public static void initFeatures() {
        MFB mf = new MFB();
        mf.register(POS, MID);
        s_str = mf.register(POS, STR);
        s_end = mf.register(POS, END);
        s_relend = mf.register(REL, END);
        _cstr = mf.register("SP", STR);
        _cend = mf.register("SP", END);
        mf.register(TYPE, POS);
        s_stwrd = mf.register(WORD, STWRD);
        mf.register(POS, STPOS);
        la = mf.register(DIR, LA);
        ra = mf.register(DIR, RA);
        mf.register(TYPE, FEAT);
        nofeat = mf.register(FEAT, "NOFEAT");
        int k = 0;
        while (k < 60) {
            mf.register(TYPE, FEAT + k);
            ++k;
        }
        d0 = mf.register(DIST, _0);
        d1 = mf.register(DIST, _1);
        d2 = mf.register(DIST, _2);
        d3 = mf.register(DIST, _3);
        d4 = mf.register(DIST, _4);
        d5 = mf.register(DIST, _5);
        d10 = mf.register(DIST, _10);
    }

    public void extractFeatures3(Instances is, int i, ParseNBest parse, int rank, long[] v) {
        int f = 1;
        int n = 0;
        short k = 0;
        while (k < is.length(i) - 1) {
            short[] chld = this.children(parse.heads, k);
            f = 2;
            int fm = is.forms[i][k];
            int hh = k != 0 ? is.pposs[i][parse.heads[k]] : s_end;
            short h = is.pposs[i][k];
            short hrel = parse.labels[k];
            int hhrel = k != 0 ? parse.labels[parse.heads[k]] : s_relend;
            int hhf = k != 0 ? is.forms[i][parse.heads[k]] : s_stwrd;
            int rlast = chld.length > 0 ? parse.labels[chld[chld.length - 1]] : s_relend;
            int[] rels = new int[chld.length];
            int[] pss = new int[chld.length];
            int j = 0;
            while (j < chld.length) {
                rels[j] = parse.labels[chld[j]];
                pss[j] = is.pposs[i][chld[j]];
                ++j;
            }
            StringBuilder rl = new StringBuilder(chld.length);
            StringBuilder psl = new StringBuilder(chld.length);
            int j2 = 0;
            while (j2 < chld.length) {
                rl.append((char)rels[j2]);
                psl.append((char)pss[j2]);
                ++j2;
            }
            int rli = this.mf.register("rli", rl.toString());
            int pli = this.mf.register("pli", psl.toString());
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.cz3();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.cz3();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = hh;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = hh;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = fm;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = hh;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = hh;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = rli;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.v5 = h;
            this.dwp.cz6();
            v[n++] = this.dwp.getVal();
            Arrays.sort(rels);
            Arrays.sort(pss);
            rl = new StringBuilder(chld.length);
            psl = new StringBuilder(chld.length);
            int j3 = 0;
            while (j3 < chld.length) {
                rl.append((char)rels[j3]);
                psl.append((char)pss[j3]);
                ++j3;
            }
            rli = this.mf.register("rli", rl.toString());
            pli = this.mf.register("pli", psl.toString());
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = fm;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dl1.v0 = f++;
            this.dl1.v2 = h;
            this.dl1.v3 = hrel;
            this.dl1.v4 = hhrel;
            this.dl1.v5 = hh;
            this.dl1.v6 = rlast;
            this.dl1.cz6();
            v[n++] = this.dl1.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = fm;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.cz5();
            v[n++] = this.dwp.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = hhf;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.v5 = h;
            this.dwp.cz6();
            v[n++] = this.dwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = hhf;
            this.dwwp.v4 = hrel;
            this.dwwp.v5 = hhrel;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = h;
            this.dwwp.v3 = hhf;
            this.dwwp.v4 = hrel;
            this.dwwp.v5 = hhrel;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = hh;
            this.dwwp.v4 = hrel;
            this.dwwp.v5 = hhrel;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = hhf;
            this.dwwp.v4 = h;
            this.dwwp.v5 = hh;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = h;
            this.dwwp.v3 = hhf;
            this.dwwp.v4 = hrel;
            this.dwwp.v5 = hh;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = hh;
            this.dwwp.v4 = h;
            this.dwwp.v5 = hrel;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            short hp = parse.heads[k];
            short[] hchld = hp == -1 ? new short[]{} : this.children(parse.heads, hp);
            int[] hrels = new int[hchld.length];
            int[] hpss = new int[hchld.length];
            int j4 = 0;
            while (j4 < hchld.length) {
                hrels[j4] = parse.labels[hchld[j4]];
                hpss[j4] = is.pposs[i][hchld[j4]];
                ++j4;
            }
            StringBuilder hrl = new StringBuilder(hchld.length);
            StringBuilder hpsl = new StringBuilder(hchld.length);
            int j5 = 0;
            while (j5 < hchld.length) {
                hrl.append((char)hrels[j5]);
                hpsl.append((char)hpss[j5]);
                ++j5;
            }
            int hrli = this.mf.register("rli", hrl.toString());
            int hpli = this.mf.register("pli", hpsl.toString());
            this.dwwp.v0 = f++;
            this.dwwp.v2 = hpli;
            this.dwwp.v3 = hrli;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = hrli;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = hpli;
            this.dwwp.v3 = fm;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = hpli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = hrel;
            this.dwwp.v5 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = hrli;
            this.dwwp.v4 = hrel;
            this.dwwp.v5 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = hpli;
            this.dwwp.v3 = hpli;
            this.dwwp.v4 = hrel;
            this.dwwp.v5 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            k = (short)(k + 1);
        }
        v[n] = Integer.MIN_VALUE;
    }

    public void extractFeatures(Instances is, int i, ParseNBest parse, int rank, long[] v, Cluster cluster) {
        int f = 1;
        int n = 0;
        short k = 0;
        while (k < is.length(i) - 1) {
            short[] chld = this.children(parse.heads, k);
            int abs = Math.abs(parse.heads[k] - k);
            int dist = abs > 10 ? d10 : (abs > 5 ? d5 : (abs == 5 ? d4 : (abs == 4 ? d3 : (abs == 3 ? d2 : (abs == 2 ? d1 : d0)))));
            f = 2;
            int fm = is.forms[i][k];
            int hh = k != 0 ? is.pposs[i][parse.heads[k]] : s_end;
            short h = is.pposs[i][k];
            short hrel = parse.labels[k];
            int hhrel = k != 0 ? parse.labels[parse.heads[k]] : s_relend;
            int hhf = k != 0 ? is.forms[i][parse.heads[k]] : s_stwrd;
            int r1 = chld.length > 0 ? parse.labels[chld[0]] : s_relend;
            int rlast = chld.length > 0 ? parse.labels[chld[chld.length - 1]] : s_relend;
            int[] rels = new int[chld.length];
            int[] pss = new int[chld.length];
            int[] cls = new int[chld.length];
            int[] rc = new int[30];
            int j = 0;
            while (j < chld.length) {
                rels[j] = parse.labels[chld[j]];
                if (rels[j] < rc.length) {
                    int n2 = rels[j];
                    rc[n2] = rc[n2] + 1;
                }
                pss[j] = is.pposs[i][chld[j]];
                ++j;
            }
            StringBuilder rl = new StringBuilder(chld.length);
            StringBuilder psl = new StringBuilder(chld.length);
            StringBuilder csl = new StringBuilder(chld.length);
            int j2 = 0;
            while (j2 < chld.length) {
                rl.append((char)rels[j2]);
                psl.append((char)pss[j2]);
                ++j2;
            }
            int rli = this.mf.register("rli", rl.toString());
            int pli = this.mf.register("pli", psl.toString());
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = fm;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.cz3();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.cz3();
            v[n++] = this.dwwp.getVal();
            int j3 = 1;
            while (j3 < rc.length) {
                this.dwwp.v0 = f++;
                this.dwwp.v2 = rc[j3] == 0 ? 1 : (rc[j3] == 1 ? 2 : 3);
                this.dwwp.v3 = j3;
                this.dwwp.cz4();
                v[n++] = this.dwwp.getVal();
                ++j3;
            }
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = hh;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = hh;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = hh;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = hh;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = rli;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.v5 = h;
            this.dwp.cz6();
            v[n++] = this.dwp.getVal();
            Arrays.sort(rels);
            Arrays.sort(pss);
            rl = new StringBuilder(chld.length);
            psl = new StringBuilder(chld.length);
            j3 = 0;
            while (j3 < chld.length) {
                rl.append((char)rels[j3]);
                psl.append((char)pss[j3]);
                ++j3;
            }
            rli = this.mf.register("rli", rl.toString());
            pli = this.mf.register("pli", psl.toString());
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = 1L;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = 1L;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = fm;
            this.dwwp.v4 = 1L;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dl1.v0 = f++;
            this.dl1.v2 = h;
            this.dl1.v3 = hrel;
            this.dl1.v4 = hhrel;
            this.dl1.v5 = hh;
            this.dl1.v6 = rlast;
            this.dl1.cz6();
            v[n++] = this.dl1.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = fm;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.cz5();
            v[n++] = this.dwp.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = hhf;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.v5 = h;
            this.dwp.cz6();
            v[n++] = this.dwp.getVal();
            k = (short)(k + 1);
        }
        v[n] = Integer.MIN_VALUE;
    }

    public void extractFeatures6(Instances is, int i, ParseNBest parse, int rank, long[] v) {
        int f = 1;
        int n = 0;
        short k = 0;
        while (k < is.length(i) - 1) {
            short[] chld = this.children(parse.heads, k);
            f = 2;
            int fm = is.forms[i][k];
            int hh = k != 0 ? is.pposs[i][parse.heads[k]] : s_end;
            short h = is.pposs[i][k];
            short hrel = parse.labels[k];
            int hhrel = k != 0 ? parse.labels[parse.heads[k]] : s_relend;
            int hhf = k != 0 ? is.forms[i][parse.heads[k]] : s_stwrd;
            int r1 = chld.length > 0 ? parse.labels[chld[0]] : s_relend;
            int rlast = chld.length > 0 ? parse.labels[chld[chld.length - 1]] : s_relend;
            int[] rels = new int[chld.length];
            int[] pss = new int[chld.length];
            int[] rc = new int[30];
            int j = 0;
            while (j < chld.length) {
                rels[j] = parse.labels[chld[j]];
                if (rels[j] < rc.length) {
                    int n2 = rels[j];
                    rc[n2] = rc[n2] + 1;
                }
                pss[j] = is.pposs[i][chld[j]];
                ++j;
            }
            StringBuilder rl = new StringBuilder(chld.length);
            StringBuilder psl = new StringBuilder(chld.length);
            int j2 = 0;
            while (j2 < chld.length) {
                rl.append((char)rels[j2]);
                psl.append((char)pss[j2]);
                ++j2;
            }
            int rli = this.mf.register("rli", rl.toString());
            int pli = this.mf.register("pli", psl.toString());
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = fm;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.cz3();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.cz3();
            v[n++] = this.dwwp.getVal();
            int j3 = 1;
            while (j3 < rc.length) {
                this.dwwp.v0 = f++;
                this.dwwp.v2 = rc[j3] == 0 ? 1 : (rc[j3] == 1 ? 2 : 3);
                this.dwwp.v3 = j3;
                this.dwwp.cz4();
                v[n++] = this.dwwp.getVal();
                ++j3;
            }
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = hh;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = hh;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = hh;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = hh;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = rli;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.v5 = h;
            this.dwp.cz6();
            v[n++] = this.dwp.getVal();
            Arrays.sort(rels);
            Arrays.sort(pss);
            rl = new StringBuilder(chld.length);
            psl = new StringBuilder(chld.length);
            j3 = 0;
            while (j3 < chld.length) {
                rl.append((char)rels[j3]);
                psl.append((char)pss[j3]);
                ++j3;
            }
            rli = this.mf.register("rli", rl.toString());
            pli = this.mf.register("pli", psl.toString());
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = 1L;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = 1L;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = fm;
            this.dwwp.v4 = 1L;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dl1.v0 = f++;
            this.dl1.v2 = h;
            this.dl1.v3 = hrel;
            this.dl1.v4 = hhrel;
            this.dl1.v5 = hh;
            this.dl1.v6 = rlast;
            this.dl1.cz6();
            v[n++] = this.dl1.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = fm;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.cz5();
            v[n++] = this.dwp.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = hhf;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.v5 = h;
            this.dwp.cz6();
            v[n++] = this.dwp.getVal();
            k = (short)(k + 1);
        }
        v[n] = Integer.MIN_VALUE;
    }

    public void extractFeatures2(Instances is, int i, ParseNBest parse, int rank, long[] v) {
        int f = 1;
        int n = 0;
        short k = 0;
        while (k < is.length(i) - 1) {
            short[] chld = this.children(parse.heads, k);
            f = 2;
            int fm = is.forms[i][k];
            int hh = k != 0 ? is.pposs[i][parse.heads[k]] : s_end;
            short h = is.pposs[i][k];
            short hrel = parse.labels[k];
            int hhrel = k != 0 ? parse.labels[parse.heads[k]] : s_relend;
            int hhf = k != 0 ? is.forms[i][parse.heads[k]] : s_stwrd;
            int r1 = chld.length > 0 ? parse.labels[chld[0]] : s_relend;
            int rlast = chld.length > 0 ? parse.labels[chld[chld.length - 1]] : s_relend;
            int[] rels = new int[chld.length];
            int[] pss = new int[chld.length];
            int j = 0;
            while (j < chld.length) {
                rels[j] = parse.labels[chld[j]];
                pss[j] = is.pposs[i][chld[j]];
                ++j;
            }
            StringBuilder rl = new StringBuilder(chld.length);
            StringBuilder psl = new StringBuilder(chld.length);
            int j2 = 0;
            while (j2 < chld.length) {
                rl.append((char)rels[j2]);
                psl.append((char)pss[j2]);
                ++j2;
            }
            int rli = this.mf.register("rli", rl.toString());
            int pli = this.mf.register("pli", psl.toString());
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = fm;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.cz3();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.cz3();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = hh;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = hh;
            this.dwwp.v4 = h;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = hh;
            this.dwwp.cz5();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = hh;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = rli;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.v5 = h;
            this.dwp.cz6();
            v[n++] = this.dwp.getVal();
            Arrays.sort(rels);
            Arrays.sort(pss);
            rl = new StringBuilder(chld.length);
            psl = new StringBuilder(chld.length);
            int j3 = 0;
            while (j3 < chld.length) {
                rl.append((char)rels[j3]);
                psl.append((char)pss[j3]);
                ++j3;
            }
            rli = this.mf.register("rli", rl.toString());
            pli = this.mf.register("pli", psl.toString());
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = 1L;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = fm;
            this.dwwp.v3 = rli;
            this.dwwp.v4 = 1L;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = pli;
            this.dwwp.v3 = fm;
            this.dwwp.v4 = 1L;
            this.dwwp.v5 = h;
            this.dwwp.cz6();
            v[n++] = this.dwwp.getVal();
            this.dwwp.v0 = f++;
            this.dwwp.v2 = rli;
            this.dwwp.v3 = h;
            this.dwwp.cz4();
            v[n++] = this.dwwp.getVal();
            this.dl1.v0 = f++;
            this.dl1.v2 = h;
            this.dl1.v3 = hrel;
            this.dl1.v4 = hhrel;
            this.dl1.v5 = hh;
            this.dl1.v6 = rlast;
            this.dl1.cz6();
            v[n++] = this.dl1.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = fm;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.cz5();
            v[n++] = this.dwp.getVal();
            this.dwp.v0 = f++;
            this.dwp.v2 = hhf;
            this.dwp.v3 = hrel;
            this.dwp.v4 = hh;
            this.dwp.v5 = h;
            this.dwp.cz6();
            v[n++] = this.dwp.getVal();
            k = (short)(k + 1);
        }
        v[n] = Integer.MIN_VALUE;
    }

    private short[] children(short[] heads, short h) {
        int c = 0;
        int k = 0;
        while (k < heads.length) {
            if (heads[k] == h) {
                ++c;
            }
            ++k;
        }
        short[] clds = new short[c];
        c = 0;
        int k2 = 0;
        while (k2 < heads.length) {
            if (heads[k2] == h) {
                clds[c++] = (short)k2;
            }
            ++k2;
        }
        return clds;
    }
}

