/*
 * Decompiled with CFR 0.152.
 */
package matetools.examples;

import java.io.File;
import matetools.is2.data.InstancesTagger;
import matetools.is2.data.SentenceData09;
import matetools.is2.io.CONLLReader09;
import matetools.is2.io.CONLLWriter09;
import matetools.is2.lemmatizer.Lemmatizer;
import matetools.is2.lemmatizer.MFO;
import matetools.is2.mtag.Tagger;
import matetools.is2.parser.Parser;

public class FullPipelineTest {
    public File lemmatizerFile;
    public File taggerFile;
    public File mtaggerFile;
    public File parserFile;

    public int execute(String source, String target) throws Throwable {
        Lemmatizer lemmatizer = new Lemmatizer(this.lemmatizerFile.getAbsolutePath());
        matetools.is2.tag.Tagger tagger = new matetools.is2.tag.Tagger(this.taggerFile.getAbsolutePath());
        Tagger mtagger = new Tagger(this.mtaggerFile.getAbsolutePath());
        Parser parser = new Parser(this.parserFile.getAbsolutePath());
        CONLLReader09 reader = new CONLLReader09(source);
        CONLLWriter09 writer = new CONLLWriter09(target);
        int count = 0;
        while (true) {
            InstancesTagger is = new InstancesTagger();
            is.init(1, new MFO());
            SentenceData09 instance = reader.getNext(is);
            if (instance == null) break;
            SentenceData09 result = null;
            try {
                System.out.print("\b\b\b\b" + count);
                result = lemmatizer.apply(instance);
                result = tagger.apply(result);
                result = mtagger.apply(result);
                result = parser.apply(result);
                ++count;
            }
            catch (Exception e) {
                System.out.println("error" + result);
                System.out.println("error" + instance);
                e.printStackTrace();
                break;
            }
            writer.write(result);
        }
        writer.finishWriting();
        return 0;
    }

    public static void main(String[] args) throws Throwable {
        if (args.length < 3) {
            System.out.println("lemmatizer-model tagger-model parser-model source target");
            System.exit(0);
        }
        FullPipelineTest p = new FullPipelineTest();
        p.lemmatizerFile = new File(args[0]);
        p.taggerFile = new File(args[1]);
        p.mtaggerFile = new File(args[2]);
        p.parserFile = new File(args[3]);
        p.execute(args[4], args[5]);
    }
}

