/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.IOUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CCGPARGWriter {
    private PrintWriter _writer;
    private int _s_id;
    public static boolean UNLAB = false;
    String fileName;

    public CCGPARGWriter(String path) {
        this._writer = IOUtils.openOutEasy(path);
        this._s_id = 0;
        this.fileName = new File(path).getName();
    }

    public void printOneSentencePARG(PredicateArgumentAdjunctDAG dag, List<String> words, List<String> cats) {
        if (words == null || words.isEmpty()) {
            words = CCGPARGWriter.genUnderlines(dag.sentenceLength());
        }
        if (cats == null || cats.isEmpty()) {
            cats = CCGPARGWriter.genUnderlines(dag.sentenceLength());
        }
        this._writer.println("<s id=\"" + this.fileName + "." + ++this._s_id + "\"> " + (dag.sentenceLength() - 1));
        int i = 1;
        while (i <= dag.sentenceLength()) {
            PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList arcList = dag.getAdjacencyLists()[i];
            for (PredicateArgumentAdjunctDAG.ArcInfo arc : arcList.getInArcs()) {
                this._writer.println(String.valueOf(i - 1) + " " + (arc.index - 1) + " " + cats.get(arc.index - 1) + " " + arc.label + " " + words.get(i - 1) + " " + words.get(arc.index - 1));
            }
            ++i;
        }
        this._writer.println("<\\s>");
    }

    public void printOneSentenceCoNLL08(PredicateArgumentAdjunctDAG dag, List<String> words, List<String> poss) {
        this.printCoNLL(CCGPARGWriter.toCoNLL08(dag, null, words, poss, false));
    }

    public void printOneSentenceCoNLL08(PredicateArgumentAdjunctDAG dag, List<String> words, List<String> poss, boolean addRoot) {
        this.printCoNLL(CCGPARGWriter.toCoNLL08(dag, null, words, poss, addRoot));
    }

    public void printOneSentenceCoNLL08(PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG syntaxTree, List<String> words, List<String> poss) {
        this.printCoNLL(CCGPARGWriter.toCoNLL08(dag, syntaxTree, words, poss, false));
    }

    public void printOneSentenceCoNLL08(PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG syntaxTree, List<String> words, List<String> poss, boolean addRoot) {
        this.printCoNLL(CCGPARGWriter.toCoNLL08(dag, syntaxTree, words, poss, addRoot));
    }

    public void printOneSentenceCoNLL09(PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG syntaxTree, List<String> words, List<String> lemmas, List<String> poss, boolean addRoot) {
        this.printCoNLL(CCGPARGWriter.toCoNLL(dag, syntaxTree, words, lemmas, poss, addRoot, CoNLLFormat.CONLL09));
    }

    public void printOneSentenceSDP(PredicateArgumentAdjunctDAG dag, List<String> words, List<String> lemmas, List<String> poss, String id) {
        this._writer.println(id);
        this.printCoNLL(CCGPARGWriter.toSDP(dag, words, lemmas, poss, null));
    }

    public void printOneSentenceSDP15(PredicateArgumentAdjunctDAG dag, List<String> words, List<String> lemmas, List<String> poss, List<String> sense, String id) {
        this._writer.println(id);
        if (sense == null) {
            sense = new ArrayList<String>();
            int i = 0;
            while (i < words.size()) {
                sense.add("_");
                ++i;
            }
        }
        this.printCoNLL(CCGPARGWriter.toSDP(dag, words, lemmas, poss, sense));
    }

    public static String[][] toSDP(PredicateArgumentAdjunctDAG dag, List<String> words, List<String> lemmas, List<String> poss, List<String> sense) {
        ArrayList<String> unescaped;
        int sentLen = dag.sentenceLength();
        if (words.size() != sentLen) {
            System.err.println("Sentence length inconsistent: " + sentLen + "," + words.size());
        }
        if (SentenceForDAGParsing.escapedWordBracket) {
            unescaped = new ArrayList<String>();
            for (String w : words) {
                unescaped.add(SentenceForDAGParsing.unescapeBracket(w));
            }
            words = unescaped;
            unescaped = new ArrayList();
            for (String w : lemmas) {
                unescaped.add(SentenceForDAGParsing.unescapeBracket(w));
            }
            lemmas = unescaped;
        }
        if (SentenceForDAGParsing.escapedPOSBracket) {
            unescaped = new ArrayList();
            for (String w : poss) {
                unescaped.add(SentenceForDAGParsing.unescapeBracket(w));
            }
            poss = unescaped;
        }
        ArrayList<List<Object>> sdp = new ArrayList<List<Object>>();
        ArrayList<String> indices = new ArrayList<String>();
        int i = 1;
        while (i <= sentLen) {
            indices.add(Integer.toString(i));
            ++i;
        }
        sdp.add(indices);
        sdp.add(words);
        if (lemmas == null || lemmas.isEmpty()) {
            lemmas = words;
        }
        sdp.add(lemmas);
        sdp.add(poss);
        ArrayList<String> negs = new ArrayList<String>();
        int j = 0;
        while (j < sentLen) {
            negs.add("-");
            ++j;
        }
        sdp.add(negs);
        negs = new ArrayList();
        j = 0;
        while (j < sentLen) {
            negs.add("-");
            ++j;
        }
        sdp.add(negs);
        if (sense != null) {
            sdp.add(sense);
        }
        PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList rootArcList = dag.getAdjacencyLists()[0];
        for (PredicateArgumentAdjunctDAG.ArcInfo arc : rootArcList.getOutArcs()) {
            ((List)sdp.get(4)).set(arc.index - 1, "+");
        }
        int i2 = 1;
        while (i2 <= dag.sentenceLength()) {
            PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList arcList = dag.getAdjacencyLists()[i2];
            int index = i2 - 1;
            if (!arcList.getOutArcs().isEmpty()) {
                ((List)sdp.get(5)).set(index, "+");
                ArrayList<String> column = new ArrayList<String>();
                int j2 = 0;
                while (j2 < sentLen) {
                    column.add("_");
                    ++j2;
                }
                for (PredicateArgumentAdjunctDAG.ArcInfo arc : arcList.getOutArcs()) {
                    if (arc.index <= 0) continue;
                    column.set(arc.index - 1, arc.label);
                }
                sdp.add(column);
            }
            ++i2;
        }
        int numOfAttri = sdp.size();
        int numOfToken = ((List)sdp.get(0)).size();
        String[][] ret = new String[numOfAttri][numOfToken];
        int i3 = 0;
        while (i3 < numOfAttri) {
            int j3 = 0;
            while (j3 < numOfToken) {
                ret[i3][j3] = (String)((List)sdp.get(i3)).get(j3);
                ++j3;
            }
            ++i3;
        }
        return ret;
    }

    public static String[][] toCoNLL08(PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG tree, List<String> words, List<String> poss, boolean addRoot) {
        return CCGPARGWriter.toCoNLL(dag, tree, words, words, poss, addRoot, CoNLLFormat.CONLL08);
    }

    public static String[][] toCoNLL(PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG tree, List<String> words, List<String> lemmas, List<String> poss, boolean addRoot, CoNLLFormat format) {
        ArrayList<String> unescaped;
        if (dag == null && tree == null) {
            throw new RuntimeException("No graph or tree!");
        }
        int sentLen = 0;
        if (dag == null) {
            sentLen = tree.sentenceLength();
            dag = new PredicateArgumentAdjunctDAG(sentLen);
        } else if (tree == null) {
            sentLen = dag.sentenceLength();
            tree = new PredicateArgumentAdjunctDAG(sentLen);
        } else {
            sentLen = dag.sentenceLength();
        }
        if (words == null || words.isEmpty()) {
            words = CCGPARGWriter.genUnderlines(sentLen);
        }
        if (lemmas == null || lemmas.isEmpty()) {
            lemmas = words;
        }
        if (poss == null || poss.isEmpty()) {
            poss = CCGPARGWriter.genUnderlines(sentLen);
        }
        if (words.size() != sentLen || lemmas.size() != sentLen || poss.size() != sentLen) {
            throw new RuntimeException("Sentence length inconsistent: " + sentLen + "," + words.size() + "," + lemmas.size() + "," + poss.size());
        }
        if (SentenceForDAGParsing.escapedWordBracket) {
            unescaped = new ArrayList<String>();
            for (String w : words) {
                unescaped.add(SentenceForDAGParsing.unescapeBracket(w));
            }
            words = unescaped;
            unescaped = new ArrayList();
            for (String w : lemmas) {
                unescaped.add(SentenceForDAGParsing.unescapeBracket(w));
            }
            lemmas = unescaped;
        }
        if (SentenceForDAGParsing.escapedPOSBracket) {
            unescaped = new ArrayList();
            for (String w : poss) {
                unescaped.add(SentenceForDAGParsing.unescapeBracket(w));
            }
            poss = unescaped;
        }
        int start = 1;
        if (addRoot) {
            words = new ArrayList<String>(words);
            lemmas = new ArrayList<String>(lemmas);
            poss = new ArrayList<String>(poss);
            words.add(0, "root");
            lemmas.add(0, "root");
            poss.add(0, "root");
            ++sentLen;
            start = 0;
        }
        ArrayList<List<Object>> conll = new ArrayList<List<Object>>();
        ArrayList<String> indices = new ArrayList<String>();
        int i = 1;
        while (i <= sentLen) {
            indices.add(Integer.toString(i));
            ++i;
        }
        conll.add(indices);
        conll.add(words);
        conll.add(lemmas);
        if (format == CoNLLFormat.CONLL09) {
            conll.add(lemmas);
        }
        conll.add(poss);
        conll.add(poss);
        i = 0;
        while (i < 6) {
            conll.add(CCGPARGWriter.genUnderlines(sentLen));
            ++i;
        }
        if (format == CoNLLFormat.CONLL09) {
            i = 0;
            while (i < 2) {
                conll.add(CCGPARGWriter.genUnderlines(sentLen));
                ++i;
            }
        }
        if (format == CoNLLFormat.CONLL08 && PredicateArgumentAdjunctDAG.CONLL08_TYPE_COL == 7) {
            i = start;
            while (i < dag.getTypes().size()) {
                int index = addRoot ? i : i - 1;
                ((List)conll.get(7)).set(index, dag.getTypes().get(i));
                ++i;
            }
        }
        if (tree != null && !tree.isEmpty()) {
            List heads = (List)conll.get(format.head);
            List labels = (List)conll.get(format.deprel);
            int i2 = 1;
            while (i2 <= tree.sentenceLength()) {
                PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList arcList = tree.getAdjacencyLists()[i2];
                if (arcList.getInArcs().size() == 1) {
                    PredicateArgumentAdjunctDAG.ArcInfo arc = arcList.getInArcs().get(0);
                    int index = addRoot ? i2 : i2 - 1;
                    heads.set(index, Integer.toString(addRoot ? arc.index + 1 : arc.index));
                    if (UNLAB) {
                        labels.set(index, "X");
                    } else {
                        labels.set(index, arc.label);
                    }
                } else {
                    System.err.println(words);
                    System.err.println(tree);
                    System.err.println(String.valueOf(words.get(i2 - 1)) + "(" + i2 + "): " + arcList.getInArcs());
                    return null;
                }
                ++i2;
            }
        }
        i = start;
        while (i <= dag.sentenceLength()) {
            int index;
            PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList arcList = dag.getAdjacencyLists()[i];
            int n = index = addRoot ? i : i - 1;
            if (!arcList.getOutArcs().isEmpty()) {
                if (PredicateArgumentAdjunctDAG.CONLL08_TYPE_COL == format.pred && dag.getTypes().size() > i && !"_".equals(dag.getTypes().get(i))) {
                    ((List)conll.get(format.pred)).set(index, String.valueOf(words.get(index)) + "_" + dag.getTypes().get(i));
                } else if (words.get(index).equals("_")) {
                    ((List)conll.get(format.pred)).set(index, "" + i);
                } else {
                    ((List)conll.get(format.pred)).set(index, words.get(index));
                }
                if (format == CoNLLFormat.CONLL09) {
                    ((List)conll.get(format.pred - 1)).set(index, "Y");
                }
                List<String> column = CCGPARGWriter.genUnderlines(sentLen);
                for (PredicateArgumentAdjunctDAG.ArcInfo arc : arcList.getOutArcs()) {
                    int depIndex;
                    if (arc.index <= 0) continue;
                    int n2 = depIndex = addRoot ? arc.index : arc.index - 1;
                    if (UNLAB) {
                        column.set(depIndex, "X");
                        continue;
                    }
                    column.set(depIndex, arc.label);
                }
                conll.add(column);
            }
            ++i;
        }
        int numOfAttri = conll.size();
        int numOfToken = ((List)conll.get(0)).size();
        String[][] ret = new String[numOfAttri][numOfToken];
        int i3 = 0;
        while (i3 < numOfAttri) {
            int j = 0;
            while (j < numOfToken) {
                ret[i3][j] = (String)((List)conll.get(i3)).get(j);
                ++j;
            }
            ++i3;
        }
        return ret;
    }

    public void printOneSentenceCoNLL06(PredicateArgumentAdjunctDAG dag) {
        this.printCoNLL(CCGPARGWriter.toCoNLL06(dag));
    }

    public void printOneSentenceCoNLL06(PredicateArgumentAdjunctDAG dag, List<String> words) {
        this.printCoNLL(CCGPARGWriter.toCoNLL06(dag, words));
    }

    public void printOneSentenceCoNLL06(PredicateArgumentAdjunctDAG dag, List<String> words, List<String> poss) {
        this.printCoNLL(CCGPARGWriter.toCoNLL06(dag, words, poss));
    }

    public static String[][] toCoNLL06(PredicateArgumentAdjunctDAG dag) {
        ArrayList<String> underlines = new ArrayList<String>();
        int i = 0;
        while (i < dag.sentenceLength()) {
            underlines.add("_");
            ++i;
        }
        return CCGPARGWriter.toCoNLL06(dag, underlines, underlines);
    }

    public static String[][] toCoNLL06(PredicateArgumentAdjunctDAG dag, List<String> words) {
        ArrayList<String> underlines = new ArrayList<String>();
        int i = 0;
        while (i < dag.sentenceLength()) {
            underlines.add("_");
            ++i;
        }
        return CCGPARGWriter.toCoNLL06(dag, words, underlines);
    }

    public static String[][] toCoNLL06(PredicateArgumentAdjunctDAG dag, List<String> words, List<String> poss) {
        ArrayList<String> unescaped;
        int sentLen = dag.sentenceLength();
        if (words.size() != sentLen) {
            System.err.println("Sentence length inconsistent: " + sentLen + "," + words.size());
        }
        if (SentenceForDAGParsing.escapedWordBracket) {
            unescaped = new ArrayList<String>();
            for (String w : words) {
                unescaped.add(SentenceForDAGParsing.unescapeBracket(w));
            }
            words = unescaped;
        }
        if (SentenceForDAGParsing.escapedPOSBracket) {
            unescaped = new ArrayList();
            for (String w : poss) {
                unescaped.add(SentenceForDAGParsing.unescapeBracket(w));
            }
            poss = unescaped;
        }
        ArrayList<List<Object>> conll06 = new ArrayList<List<Object>>();
        ArrayList<String> indices = new ArrayList<String>();
        int i = 1;
        while (i <= sentLen) {
            indices.add("" + i);
            ++i;
        }
        conll06.add(indices);
        i = 1;
        while (i < 3) {
            conll06.add(words);
            ++i;
        }
        i = 3;
        while (i < 5) {
            conll06.add(poss);
            ++i;
        }
        ArrayList<String> underlines = new ArrayList<String>();
        int j = 0;
        while (j < sentLen) {
            underlines.add("_");
            ++j;
        }
        conll06.add(underlines);
        int i2 = 6;
        while (i2 < 10) {
            underlines = new ArrayList();
            int j2 = 0;
            while (j2 < sentLen) {
                underlines.add("_");
                ++j2;
            }
            conll06.add(underlines);
            ++i2;
        }
        List heads = (List)conll06.get(6);
        List labels = (List)conll06.get(7);
        int i3 = 1;
        while (i3 <= dag.sentenceLength()) {
            PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList arcList = dag.getAdjacencyLists()[i3];
            if (arcList.getInArcs().size() == 1) {
                PredicateArgumentAdjunctDAG.ArcInfo arc = arcList.getInArcs().get(0);
                heads.set(i3 - 1, "" + arc.index);
                labels.set(i3 - 1, arc.label);
            }
            ++i3;
        }
        int numOfAttri = conll06.size();
        int numOfToken = ((List)conll06.get(0)).size();
        String[][] ret = new String[numOfAttri][numOfToken];
        int i4 = 0;
        while (i4 < numOfAttri) {
            int j3 = 0;
            while (j3 < numOfToken) {
                ret[i4][j3] = (String)((List)conll06.get(i4)).get(j3);
                ++j3;
            }
            ++i4;
        }
        return ret;
    }

    public void printCoNLL(String[][] conll, String delimeter) {
        if (conll.length < 1) {
            return;
        }
        int numOfToken = conll[0].length;
        int numOfAttri = conll.length;
        int row = 0;
        while (row < numOfToken) {
            int col = 0;
            while (col < numOfAttri - 1) {
                this._writer.print(String.valueOf(conll[col][row]) + delimeter);
                ++col;
            }
            this._writer.println(conll[numOfAttri - 1][row]);
            ++row;
        }
        this._writer.println();
    }

    public void printCoNLL(String[][] conll) {
        this.printCoNLL(conll, "\t");
    }

    public void close() {
        this._writer.close();
    }

    public void flush() {
        this._writer.flush();
    }

    private static List<String> genUnderlines(int l) {
        ArrayList<String> underlines = new ArrayList<String>(l);
        int i = 0;
        while (i < l) {
            underlines.add("_");
            ++i;
        }
        return underlines;
    }

    public void printOneSentence(SentenceForDAGParsing s, String dataFormat, boolean predicted) {
        this.printOneSentence(s, dataFormat, predicted, false);
    }

    public void printOneSentence(SentenceForDAGParsing s, String dataFormat, boolean predicted, boolean addRoot) {
        PredicateArgumentAdjunctDAG dag = s.getGoldDAG();
        if (predicted) {
            dag = s.getPredictedDAG();
        }
        if ("sdp".equalsIgnoreCase(dataFormat)) {
            String id = s.id();
            this.printOneSentenceSDP(dag, Arrays.asList(s.words()), Arrays.asList(s.lemmas()), Arrays.asList(s.tags()), id);
        } else if ("conll08".equalsIgnoreCase(dataFormat)) {
            PredicateArgumentAdjunctDAG tree = s.getSyntaxTree();
            this.printOneSentenceCoNLL08(dag, tree, Arrays.asList(s.words()), Arrays.asList(s.tags()), addRoot);
        } else if ("sdp15".equalsIgnoreCase(dataFormat)) {
            String id = s.id();
            this.printOneSentenceSDP15(dag, Arrays.asList(s.words()), Arrays.asList(s.lemmas()), Arrays.asList(s.tags()), Arrays.asList(s.getSense()), id);
        }
    }

    public static enum CoNLLFormat {
        CONLL06(6, 7, -1),
        CONLL08(8, 9, 10),
        CONLL09(8, 10, 13);

        int head;
        int deprel;
        int pred;

        private CoNLLFormat(int h, int d, int p) {
            this.head = h;
            this.deprel = d;
            this.pred = p;
        }
    }
}

