/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocInverter;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;

final class DocInverterPerField
extends DocFieldConsumerPerField {
    private final DocInverterPerThread perThread;
    private final FieldInfo fieldInfo;
    final InvertedDocConsumerPerField consumer;
    final InvertedDocEndConsumerPerField endConsumer;
    final DocumentsWriter.DocState docState;
    final DocInverter.FieldInvertState fieldState;

    public DocInverterPerField(DocInverterPerThread perThread, FieldInfo fieldInfo) {
        this.perThread = perThread;
        this.fieldInfo = fieldInfo;
        this.docState = perThread.docState;
        this.fieldState = perThread.fieldState;
        this.consumer = perThread.consumer.addField(this, fieldInfo);
        this.endConsumer = perThread.endConsumer.addField(this, fieldInfo);
    }

    void abort() {
        this.consumer.abort();
        this.endConsumer.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFields(Fieldable[] fields, int count) throws IOException {
        this.fieldState.reset(this.docState.doc.getBoost());
        int maxFieldLength = this.docState.maxFieldLength;
        boolean doInvert = this.consumer.start(fields, count);
        for (int i = 0; i < count; ++i) {
            Fieldable field = fields[i];
            if (!field.isIndexed() || !doInvert) continue;
            if (this.fieldState.length > 0) {
                this.fieldState.position += this.docState.analyzer.getPositionIncrementGap(this.fieldInfo.name);
            }
            if (!field.isTokenized()) {
                Object var12_18;
                String stringValue = field.stringValue();
                int valueLength = stringValue.length();
                Token token = this.perThread.localToken.reinit(stringValue, this.fieldState.offset, this.fieldState.offset + valueLength);
                boolean success = false;
                try {
                    this.consumer.add(token);
                    success = true;
                    var12_18 = null;
                    if (!success) {
                        this.docState.docWriter.setAborting();
                    }
                }
                catch (Throwable throwable) {
                    var12_18 = null;
                    if (!success) {
                        this.docState.docWriter.setAborting();
                    }
                    throw throwable;
                }
                this.fieldState.offset += valueLength;
                ++this.fieldState.length;
                ++this.fieldState.position;
            } else {
                Object var16_21;
                TokenStream stream;
                TokenStream streamValue = field.tokenStreamValue();
                if (streamValue != null) {
                    stream = streamValue;
                } else {
                    Reader reader;
                    Reader readerValue = field.readerValue();
                    if (readerValue != null) {
                        reader = readerValue;
                    } else {
                        String stringValue = field.stringValue();
                        if (stringValue == null) {
                            throw new IllegalArgumentException("field must have either TokenStream, String or Reader value");
                        }
                        this.perThread.stringReader.init(stringValue);
                        reader = this.perThread.stringReader;
                    }
                    stream = this.docState.analyzer.reusableTokenStream(this.fieldInfo.name, reader);
                }
                stream.reset();
                try {
                    Token token;
                    int offsetEnd = this.fieldState.offset - 1;
                    Token localToken = this.perThread.localToken;
                    while ((token = stream.next(localToken)) != null) {
                        Object var14_20;
                        this.fieldState.position += token.getPositionIncrement() - 1;
                        boolean success = false;
                        try {
                            this.consumer.add(token);
                            success = true;
                            var14_20 = null;
                            if (!success) {
                                this.docState.docWriter.setAborting();
                            }
                        }
                        catch (Throwable throwable) {
                            var14_20 = null;
                            if (!success) {
                                this.docState.docWriter.setAborting();
                            }
                            throw throwable;
                        }
                        ++this.fieldState.position;
                        offsetEnd = this.fieldState.offset + token.endOffset();
                        if (++this.fieldState.length < maxFieldLength) continue;
                        if (this.docState.infoStream == null) break;
                        this.docState.infoStream.println("maxFieldLength " + maxFieldLength + " reached for field " + this.fieldInfo.name + ", ignoring following tokens");
                        break;
                    }
                    this.fieldState.offset = offsetEnd + 1;
                    var16_21 = null;
                }
                catch (Throwable throwable) {
                    var16_21 = null;
                    stream.close();
                    throw throwable;
                }
                stream.close();
                {
                }
            }
            this.fieldState.boost *= field.getBoost();
        }
        this.consumer.finish();
        this.endConsumer.finish();
    }
}

