/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.record.CommandNode;
import fig.record.ConstantSubsetHint;
import fig.record.FullRecordNode;
import fig.record.LocalCommandEnv;
import fig.record.RecordNode;
import fig.record.SubsetHint;
import fig.record.SubsetOracle;
import java.util.List;

public class SubsetHintUtils {
    public static RecordNode applyHint(SubsetHint hint, RecordNode result) {
        return SubsetHintUtils.applyHint(hint, result, null, null);
    }

    public static RecordNode applyHint(SubsetHint hint, RecordNode result, CommandNode cmd, LocalCommandEnv localEnv) {
        if (hint == ConstantSubsetHint.allHint && cmd == null) {
            return result;
        }
        FullRecordNode newResult = new FullRecordNode(result.getKey(), result.getValue());
        List<RecordNode> childRecords = result.getChildren();
        SubsetOracle oracle = hint.getOracle(childRecords.size());
        int lower = oracle.getLowerBound();
        int upper = Math.min(oracle.getUpperBound(), childRecords.size());
        int i = lower;
        while (i < upper) {
            RecordNode childRecord = childRecords.get(i);
            if (oracle.inSubset(i)) {
                if (cmd == null) {
                    newResult.addChild(childRecord);
                } else {
                    newResult.addChild(cmd.exec(localEnv.withCurrRecord(childRecord).withIndex(i)));
                }
            }
            ++i;
        }
        return newResult;
    }
}

