/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.TreePanel;
import LinguaView.syntax.AttributeValueMatrix;
import LinguaView.syntax.ConstTree;
import LinguaView.syntax.ConstTreePanel;
import LinguaView.syntax.FeatureLayoutPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LFGStructPanel
extends TreePanel<Element> {
    private FeatureStructure fstruct = new FeatureStructure();
    private ConstStructure cstruct = new ConstStructure();
    int cfGap = 50;
    int cLeftMarginOrig;
    int fLeftMarginOrig;
    int cTopMarginOrig;
    int fTopMarginOrig;
    Map<ConstTree, Integer> CorrespondenceTable;
    public boolean isColor;
    public boolean isShown;

    public LFGStructPanel() {
        this.cLeftMarginOrig = this.cstruct.leftMargin;
        this.fLeftMarginOrig = this.fstruct.leftMargin;
        this.cTopMarginOrig = this.cstruct.topMargin;
        this.fTopMarginOrig = this.fstruct.topMargin;
        this.CorrespondenceTable = new HashMap<ConstTree, Integer>();
        this.isColor = true;
        this.isShown = true;
    }

    @Override
    public void loadFont() {
        this.font = new Font("SansSerif", 0, this.fontSize);
        this.metrics = this.getFontMetrics(this.font);
        this.fontDescendent = this.metrics.getDescent();
        this.fontHight = this.metrics.getHeight();
        this.levelSize = (double)this.fontHight * this.levelSizeFactor;
        this.cstruct.fontSize = this.fontSize;
        this.cstruct.font = this.font;
        this.cstruct.metrics = this.metrics;
        this.cstruct.fontDescendent = this.fontDescendent;
        this.cstruct.fontHight = this.fontHight;
        this.cstruct.levelSize = this.levelSize;
        this.fstruct.fontSize = this.fontSize;
        this.fstruct.font = this.font;
        this.fstruct.metrics = this.metrics;
        this.fstruct.fontDescendent = this.fontDescendent;
        this.fstruct.fontHight = this.fontHight;
        this.fstruct.levelSize = this.levelSize;
    }

    @Override
    public void init() {
        this.cstruct.leftMargin = this.cLeftMarginOrig;
        this.fstruct.leftMargin = this.fLeftMarginOrig;
        this.cstruct.topMargin = this.cTopMarginOrig;
        this.fstruct.topMargin = this.fTopMarginOrig;
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.setSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void render(Graphics2D g2) {
        int diff;
        g2.setFont(this.font);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke());
        int cSpan = this.cstruct.getDimension().height - this.cstruct.topMargin;
        int fSpan = this.fstruct.getDimension().height - this.fstruct.topMargin;
        int cYMiddle = this.cstruct.topMargin + cSpan / 2;
        int fYMiddle = this.fstruct.topMargin + fSpan / 2;
        if (cYMiddle > fYMiddle) {
            diff = cYMiddle - fYMiddle;
            this.fstruct.topMargin += diff;
        } else {
            diff = fYMiddle - cYMiddle;
            this.cstruct.topMargin += diff;
        }
        this.cstruct.init();
        this.fstruct.init();
        this.cstruct.render(g2);
        this.fstruct.render(g2);
        if (this.isShown && this.isAllRefValid()) {
            int RefLineFringe = this.cstruct.getDimension().height;
            int RefLineCount = 1;
            if (this.isColor) {
                g2.setColor(Color.MAGENTA);
            }
            int i = 0;
            while (i < this.cstruct.nodesCount) {
                if (this.CorrespondenceTable.get(this.cstruct.nodesArray[i]) != null) {
                    int fID = this.CorrespondenceTable.get(this.cstruct.nodesArray[i]);
                    AttributeValueMatrix headNode = (AttributeValueMatrix)this.fstruct.treebank.get(0);
                    AttributeValueMatrix targNode = headNode.getSpecifiedNode(fID);
                    AttributeValueMatrix realTargNode = AttributeValueMatrix.getRealContent(targNode);
                    int j = (Integer)this.fstruct.indexTable.get(realTargNode);
                    int Xs = this.cstruct.XMiddleArray[i] + this.cstruct.nodeLengthsArray[i] / 2 + 5;
                    int Ys = this.cstruct.YTopArray[i] + this.fontHight / 2;
                    int Xe = this.fstruct.XLeftArray[j];
                    int Ye = (this.fstruct.YUpArray[j] + this.fstruct.YDownArray[j]) / 2;
                    this.drawRefLine(Xs, Ys, Xe, Ye, g2);
                    ++RefLineCount;
                }
                ++i;
            }
            g2.setColor(Color.BLACK);
        }
    }

    public void flipSkewedLines() {
        this.cstruct.skewedLines = !this.cstruct.skewedLines;
    }

    public void flipDisplayLA() {
        this.cstruct.displayLA = !this.cstruct.displayLA;
    }

    public boolean isAllRefValid() {
        AttributeValueMatrix headNode = (AttributeValueMatrix)this.fstruct.treebank.get(0);
        int i = 0;
        while (i < this.cstruct.nodesCount) {
            int fID;
            AttributeValueMatrix targNode;
            if (this.CorrespondenceTable.get(this.cstruct.nodesArray[i]) != null && (targNode = headNode.getSpecifiedNode(fID = this.CorrespondenceTable.get(this.cstruct.nodesArray[i]).intValue())) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void drawRefLine(int x1, int y1, int x2, int y2, Graphics2D g2) {
        GeneralPath shape = new GeneralPath();
        Point p1 = new Point(x1, y1);
        Point p2 = new Point((x1 + x2) / 2, (y1 + y2) / 2);
        Point p3 = new Point(x2, y2);
        shape.moveTo(p1.x, p1.y);
        shape.curveTo(p1.x, p1.y, (p1.x + p2.x) / 2, p1.y, p2.x, p2.y);
        shape.curveTo(p2.x, p2.y, (p2.x + p3.x) / 2, p3.y, p3.x, p3.y);
        shape.moveTo(p3.x, p3.y);
        shape.closePath();
        g2.draw(shape);
        int arrowSize = g2.getFont().getSize() / 5;
        int[] arrowX = new int[4];
        int[] arrowY = new int[4];
        arrowX[0] = x2 - arrowSize;
        arrowX[1] = arrowX[0] - arrowSize;
        arrowX[2] = x2;
        arrowX[3] = arrowX[0] - arrowSize;
        arrowY[0] = y2;
        arrowY[1] = y2 - arrowSize;
        arrowY[2] = y2;
        arrowY[3] = y2 + arrowSize;
        g2.fillPolygon(arrowX, arrowY, 4);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.render(g2);
    }

    @Override
    public void loadSentence() {
        Node child;
        Element headNode = (Element)this.treebank.get(this.sentenceNumber);
        NodeList children = headNode.getChildNodes();
        String constStr = new String();
        Node cstructNode = null;
        Element fstructNode = null;
        int i = 0;
        while (i < children.getLength()) {
            child = children.item(i);
            if (child instanceof Element && child.getNodeName() == "cstruct") {
                cstructNode = (Element)child;
            } else if (child instanceof Element && child.getNodeName() == "fstruct") {
                fstructNode = (Element)child;
            }
            ++i;
        }
        if (cstructNode != null) {
            children = cstructNode.getChildNodes();
        }
        i = 0;
        while (i < children.getLength()) {
            child = children.item(i);
            if (child instanceof Text) {
                constStr = ((Text)child).getTextContent();
            }
            ++i;
        }
        if (!constStr.isEmpty()) {
            ArrayList<ConstTree> cStructbank = new ArrayList<ConstTree>();
            ConstTree cStructHead = ConstTree.ConstTreeIO.ReadConstTree(constStr);
            if (cStructHead.getLabel() != null) {
                this.buildCorrepondenceTable(cStructHead);
            }
            cStructbank.add(cStructHead);
            this.cstruct.loadTreebank(cStructbank);
            this.cstruct.setXStartPos(0);
        }
        Dimension cArea = this.cstruct.getDimension();
        int fstructStartPos = 0;
        if (cArea.width != 0) {
            int cstructEndPos = cArea.width;
            fstructStartPos = cstructEndPos + this.cfGap;
        }
        if (fstructNode != null) {
            ArrayList<AttributeValueMatrix> fStructbank = new ArrayList<AttributeValueMatrix>();
            AttributeValueMatrix fStructHead = AttributeValueMatrix.parseXMLSentence(fstructNode);
            fStructbank.add(fStructHead);
            this.fstruct.loadTreebank(fStructbank);
            this.fstruct.setXStartPos(fstructStartPos);
        }
        Dimension fArea = this.fstruct.getDimension();
        this.area.height = cArea.height > fArea.height ? cArea.height : fArea.height;
        this.area.width = cArea.width > fArea.width ? cArea.width : fArea.width;
    }

    private void buildCorrepondenceTable(ConstTree headNode) {
        List<ConstTree> L = headNode.constSubTreeList();
        for (ConstTree n : L) {
            if (!((String)n.getLabel()).trim().matches("^[A-Za-z]*#[0-9]*$")) continue;
            String[] splittedParts = ((String)n.getLabel()).trim().split("#");
            String labelOrig = splittedParts[0];
            String idStr = splittedParts[1];
            n.setLabel(labelOrig);
            this.CorrespondenceTable.put(n, Integer.parseInt(idStr));
        }
    }

    class ConstStructure
    extends ConstTreePanel {
        ConstStructure() {
        }

        @Override
        public void init() {
            this.loadFont();
            this.loadSentence();
            this.setPreferredSize(this.area);
        }

        public void setXStartPos(int XStartPos) {
            LFGStructPanel.this.cLeftMarginOrig = this.leftMargin;
            this.leftMargin += XStartPos;
            this.init();
        }
    }

    class FeatureStructure
    extends FeatureLayoutPanel {
        FeatureStructure() {
        }

        @Override
        public void init() {
            this.levelSizeFactor = 0.5;
            this.XLeftMargin = 15;
            this.XBoarderLineMargin = 20;
            this.CurlyBracketMargin = 10;
            this.XRightMargin = 15;
            this.RefLineHeight = 10;
            this.loadFont();
            this.loadSentence();
            this.setPreferredSize(this.area);
        }

        public void setXStartPos(int XStartPos) {
            LFGStructPanel.this.fLeftMarginOrig = this.leftMargin;
            this.leftMargin += XStartPos;
            this.init();
        }
    }
}

