/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PStack;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.Timer;

public class PCanvas
extends JComponent
implements PComponent {
    private static final long serialVersionUID = 1L;
    public static final String INTERATING_CHANGED_NOTIFICATION = "INTERATING_CHANGED_NOTIFICATION";
    public static final String INTERACTING_CHANGED_NOTIFICATION = "INTERACTING_CHANGED_NOTIFICATION";
    public static final String PROPERTY_INTERACTING = "INTERACTING_CHANGED_NOTIFICATION";
    public static PCanvas CURRENT_ZCANVAS = null;
    private PCamera camera;
    private final PStack cursorStack;
    private int interacting;
    private int normalRenderQuality;
    private int animatingRenderQuality;
    private int interactingRenderQuality;
    private transient PPanEventHandler panEventHandler;
    private transient PZoomEventHandler zoomEventHandler;
    private boolean paintingImmediately;
    private boolean animatingOnLastPaint;
    private transient MouseListener mouseListener;
    private transient KeyEventPostProcessor keyEventPostProcessor;
    private transient MouseWheelListener mouseWheelListener;
    private transient MouseMotionListener mouseMotionListener;
    private static final int ALL_BUTTONS_MASK = 7168;
    private boolean isButton1Pressed;
    private boolean isButton2Pressed;
    private boolean isButton3Pressed;
    private PBounds repaintBounds = new PBounds();

    public PCanvas() {
        CURRENT_ZCANVAS = this;
        this.cursorStack = new PStack();
        this.setCamera(this.createDefaultCamera());
        this.setDefaultRenderQuality(1);
        this.setAnimatingRenderQuality(0);
        this.setInteractingRenderQuality(0);
        this.setPanEventHandler(new PPanEventHandler());
        this.setZoomEventHandler(new PZoomEventHandler());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (hierarchyEvent.getComponent() == PCanvas.this) {
                    if (PCanvas.this.getParent() == null) {
                        PCanvas.this.removeInputSources();
                    } else if (PCanvas.this.isEnabled()) {
                        PCanvas.this.installInputSources();
                    }
                }
            }
        });
    }

    protected PCamera createDefaultCamera() {
        return PUtil.createBasicScenegraph();
    }

    public PPanEventHandler getPanEventHandler() {
        return this.panEventHandler;
    }

    public void setPanEventHandler(PPanEventHandler pPanEventHandler) {
        if (this.panEventHandler != null) {
            this.removeInputEventListener(this.panEventHandler);
        }
        this.panEventHandler = pPanEventHandler;
        if (this.panEventHandler != null) {
            this.addInputEventListener(this.panEventHandler);
        }
    }

    public PZoomEventHandler getZoomEventHandler() {
        return this.zoomEventHandler;
    }

    public void setZoomEventHandler(PZoomEventHandler pZoomEventHandler) {
        if (this.zoomEventHandler != null) {
            this.removeInputEventListener(this.zoomEventHandler);
        }
        this.zoomEventHandler = pZoomEventHandler;
        if (this.zoomEventHandler != null) {
            this.addInputEventListener(this.zoomEventHandler);
        }
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setCamera(PCamera pCamera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = pCamera;
        if (this.camera != null) {
            this.camera.setComponent(this);
            this.camera.setBounds(this.getBounds());
        }
    }

    public PRoot getRoot() {
        return this.camera.getRoot();
    }

    public PLayer getLayer() {
        return this.camera.getLayer(0);
    }

    public void addInputEventListener(PInputEventListener pInputEventListener) {
        this.getCamera().addInputEventListener(pInputEventListener);
    }

    public void removeInputEventListener(PInputEventListener pInputEventListener) {
        this.getCamera().removeInputEventListener(pInputEventListener);
    }

    public boolean getInteracting() {
        return this.interacting > 0 || this.getRoot().getInteracting();
    }

    public boolean getAnimating() {
        return this.getRoot().getActivityScheduler().getAnimating();
    }

    public void setInteracting(boolean bl) {
        int n;
        int n2 = this.getInteracting();
        this.interacting = bl ? ++this.interacting : --this.interacting;
        if (!this.getInteracting()) {
            n = this.normalRenderQuality;
            if (this.getAnimating()) {
                n = this.animatingRenderQuality;
            }
            if (n > this.interactingRenderQuality) {
                this.repaint();
            }
        }
        if (n2 != (n = (int)(this.getInteracting() ? 1 : 0))) {
            this.firePropertyChange("INTERACTING_CHANGED_NOTIFICATION", n2 != 0, n != 0);
        }
    }

    public void setDefaultRenderQuality(int n) {
        this.normalRenderQuality = n;
        this.repaint();
    }

    public void setAnimatingRenderQuality(int n) {
        this.animatingRenderQuality = n;
        if (this.getAnimating()) {
            this.repaint();
        }
    }

    public void setInteractingRenderQuality(int n) {
        this.interactingRenderQuality = n;
        if (this.getInteracting()) {
            this.repaint();
        }
    }

    public void pushCursor(Cursor cursor) {
        this.cursorStack.push(this.getCursor());
        this.setCursor(cursor);
    }

    public void popCursor() {
        if (!this.cursorStack.isEmpty()) {
            this.setCursor((Cursor)this.cursorStack.pop());
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.isEnabled() && this.getParent() != null) {
            this.installInputSources();
        } else {
            this.removeInputSources();
        }
    }

    protected void installInputSources() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseEventInputSource();
            this.addMouseListener(this.mouseListener);
        }
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionInputSourceListener();
            this.addMouseMotionListener(this.mouseMotionListener);
        }
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = new MouseWheelInputSourceListener();
            this.addMouseWheelListener(this.mouseWheelListener);
        }
        if (this.keyEventPostProcessor == null) {
            this.keyEventPostProcessor = new KeyEventInputSourceListener();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.keyEventPostProcessor);
        }
    }

    protected void removeInputSources() {
        this.removeMouseListener(this.mouseListener);
        this.removeMouseMotionListener(this.mouseMotionListener);
        this.removeMouseWheelListener(this.mouseWheelListener);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.keyEventPostProcessor);
        this.mouseListener = null;
        this.mouseMotionListener = null;
        this.mouseWheelListener = null;
        this.keyEventPostProcessor = null;
    }

    protected void sendInputEventToInputManager(InputEvent inputEvent, int n) {
        this.getRoot().getDefaultInputManager().processEventFromCamera(inputEvent, n, this.getCamera());
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.camera.setBounds(this.camera.getX(), this.camera.getY(), n3, n4);
        super.setBounds(n, n2, n3, n4);
    }

    public void repaint(PBounds pBounds) {
        PDebug.processRepaint();
        pBounds.expandNearestIntegerDimensions();
        pBounds.inset(-1.0, -1.0);
        this.repaint((int)pBounds.x, (int)pBounds.y, (int)pBounds.width, (int)pBounds.height);
    }

    public void paintComponent(Graphics graphics) {
        PDebug.startProcessingOutput();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.getAnimating()) {
            this.repaintBounds.add(graphics2D.getClipBounds());
        }
        PPaintContext pPaintContext = new PPaintContext(graphics2D);
        if (this.getInteracting() || this.getAnimating()) {
            if (this.interactingRenderQuality < this.animatingRenderQuality) {
                pPaintContext.setRenderQuality(this.interactingRenderQuality);
            } else {
                pPaintContext.setRenderQuality(this.animatingRenderQuality);
            }
        } else {
            pPaintContext.setRenderQuality(this.normalRenderQuality);
        }
        this.camera.fullPaint(pPaintContext);
        if (!this.getAnimating() && this.animatingOnLastPaint) {
            this.repaint(this.repaintBounds);
            this.repaintBounds.reset();
        }
        this.animatingOnLastPaint = this.getAnimating();
        PDebug.endProcessingOutput(graphics2D);
    }

    public void paintImmediately() {
        if (this.paintingImmediately) {
            return;
        }
        this.paintingImmediately = true;
        RepaintManager.currentManager(this).paintDirtyRegions();
        this.paintingImmediately = false;
    }

    public Timer createTimer(int n, ActionListener actionListener) {
        return new Timer(n, actionListener);
    }

    public int getDefaultRenderQuality() {
        return this.normalRenderQuality;
    }

    public int getNormalRenderQuality() {
        return this.normalRenderQuality;
    }

    public int getAnimatingRenderQuality() {
        return this.animatingRenderQuality;
    }

    public int getInteractingRenderQuality() {
        return this.interactingRenderQuality;
    }

    public PInputEventListener[] getInputEventListeners() {
        return this.camera.getInputEventListeners();
    }

    public void printAll(Graphics graphics) {
        if (!(graphics instanceof Graphics2D)) {
            throw new IllegalArgumentException("Provided graphics context is not a Graphics2D object");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        PBounds pBounds = new PBounds(graphics.getClipBounds());
        pBounds.expandNearestIntegerDimensions();
        PBounds pBounds2 = this.getCamera().getBounds();
        PBounds pBounds3 = this.getCamera().getUnionOfLayerFullBounds();
        this.getCamera().setBounds(pBounds3);
        double d = pBounds.getWidth() / pBounds.getHeight();
        double d2 = (double)this.getWidth() / (double)this.getHeight();
        double d3 = d2 <= d ? pBounds.getHeight() / this.getCamera().getHeight() : pBounds.getWidth() / this.getCamera().getWidth();
        graphics2D.scale(d3, d3);
        graphics2D.translate(-pBounds.x, -pBounds.y);
        PPaintContext pPaintContext = new PPaintContext(graphics2D);
        pPaintContext.setRenderQuality(1);
        this.getCamera().fullPaint(pPaintContext);
        this.getCamera().setBounds(pBounds2);
    }

    private boolean isAnyButtonDown(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiersEx() & 0x1C00) != 0;
    }

    private final class MouseWheelInputSourceListener
    implements MouseWheelListener {
        private MouseWheelInputSourceListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            PCanvas.this.sendInputEventToInputManager(mouseWheelEvent, mouseWheelEvent.getScrollType());
            if (!mouseWheelEvent.isConsumed() && PCanvas.this.getParent() != null) {
                PCanvas.this.getParent().dispatchEvent(mouseWheelEvent);
            }
        }
    }

    private final class KeyEventInputSourceListener
    implements KeyEventPostProcessor {
        private KeyEventInputSourceListener() {
        }

        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            for (Component component = FocusManager.getCurrentManager().getFocusOwner(); component != null; component = component.getParent()) {
                if (component != PCanvas.this) continue;
                PCanvas.this.sendInputEventToInputManager(keyEvent, keyEvent.getID());
                return true;
            }
            return false;
        }
    }

    private final class MouseEventInputSource
    implements MouseListener {
        private MouseEventInputSource() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            PCanvas.this.sendInputEventToInputManager(mouseEvent, 500);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = null;
            mouseEvent2 = PCanvas.this.isAnyButtonDown(mouseEvent) ? this.buildRetypedMouseEvent(mouseEvent, 506) : this.buildRetypedMouseEvent(mouseEvent, 503);
            PCanvas.this.sendInputEventToInputManager(mouseEvent, 504);
            PCanvas.this.sendInputEventToInputManager(mouseEvent2, mouseEvent2.getID());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = null;
            mouseEvent2 = PCanvas.this.isAnyButtonDown(mouseEvent) ? this.buildRetypedMouseEvent(mouseEvent, 506) : this.buildRetypedMouseEvent(mouseEvent, 503);
            PCanvas.this.sendInputEventToInputManager(mouseEvent2, mouseEvent2.getID());
            PCanvas.this.sendInputEventToInputManager(mouseEvent, 505);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            PCanvas.this.requestFocus();
            boolean bl = false;
            MouseEvent mouseEvent2 = this.copyButtonsFromModifiers(mouseEvent, 501);
            switch (mouseEvent2.getButton()) {
                case 1: {
                    if (PCanvas.this.isButton1Pressed) {
                        bl = true;
                    }
                    PCanvas.this.isButton1Pressed = true;
                    break;
                }
                case 2: {
                    if (PCanvas.this.isButton2Pressed) {
                        bl = true;
                    }
                    PCanvas.this.isButton2Pressed = true;
                    break;
                }
                case 3: {
                    if (PCanvas.this.isButton3Pressed) {
                        bl = true;
                    }
                    PCanvas.this.isButton3Pressed = true;
                    break;
                }
                default: {
                    throw new RuntimeException("mousePressed without buttons specified");
                }
            }
            if (bl) {
                this.sendRetypedMouseEventToInputManager(mouseEvent2, 502);
            }
            PCanvas.this.sendInputEventToInputManager(mouseEvent2, 501);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            boolean bl = false;
            MouseEvent mouseEvent2 = this.copyButtonsFromModifiers(mouseEvent, 502);
            switch (mouseEvent2.getButton()) {
                case 1: {
                    if (!PCanvas.this.isButton1Pressed) {
                        bl = true;
                    }
                    PCanvas.this.isButton1Pressed = false;
                    break;
                }
                case 2: {
                    if (!PCanvas.this.isButton2Pressed) {
                        bl = true;
                    }
                    PCanvas.this.isButton2Pressed = false;
                    break;
                }
                case 3: {
                    if (!PCanvas.this.isButton3Pressed) {
                        bl = true;
                    }
                    PCanvas.this.isButton3Pressed = false;
                    break;
                }
                default: {
                    throw new RuntimeException("mouseReleased without buttons specified");
                }
            }
            if (bl) {
                this.sendRetypedMouseEventToInputManager(mouseEvent2, 501);
            }
            PCanvas.this.sendInputEventToInputManager(mouseEvent2, 502);
        }

        private MouseEvent copyButtonsFromModifiers(MouseEvent mouseEvent, int n) {
            if (mouseEvent.getButton() != 0) {
                return mouseEvent;
            }
            int n2 = 0;
            if (this.hasButtonModifier(mouseEvent, 16)) {
                n2 = 1;
            } else if (this.hasButtonModifier(mouseEvent, 8)) {
                n2 = 2;
            } else if (this.hasButtonModifier(mouseEvent, 4)) {
                n2 = 3;
            }
            return this.buildModifiedMouseEvent(mouseEvent, n, n2);
        }

        private boolean hasButtonModifier(MouseEvent mouseEvent, int n) {
            return (mouseEvent.getModifiers() & n) == n;
        }

        public MouseEvent buildRetypedMouseEvent(MouseEvent mouseEvent, int n) {
            return this.buildModifiedMouseEvent(mouseEvent, n, mouseEvent.getButton());
        }

        public MouseEvent buildModifiedMouseEvent(MouseEvent mouseEvent, int n, int n2) {
            return new MouseEvent((Component)mouseEvent.getSource(), n, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), n2);
        }

        private void sendRetypedMouseEventToInputManager(MouseEvent mouseEvent, int n) {
            MouseEvent mouseEvent2 = this.buildRetypedMouseEvent(mouseEvent, n);
            PCanvas.this.sendInputEventToInputManager(mouseEvent2, n);
        }
    }

    private final class MouseMotionInputSourceListener
    implements MouseMotionListener {
        private MouseMotionInputSourceListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            PCanvas.this.sendInputEventToInputManager(mouseEvent, 506);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            PCanvas.this.sendInputEventToInputManager(mouseEvent, 503);
        }
    }
}

